/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.deployment;

import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.vertx.http.deployment.FilterBuildItem;
import io.quarkus.websockets.client.deployment.AnnotatedWebsocketEndpointBuildItem;
import io.quarkus.websockets.client.deployment.ServerWebSocketContainerBuildItem;
import io.quarkus.websockets.client.deployment.ServerWebSocketContainerFactoryBuildItem;
import io.quarkus.websockets.client.deployment.WebSocketDeploymentInfoBuildItem;
import io.quarkus.websockets.client.deployment.WebsocketClientProcessor;
import io.quarkus.websockets.runtime.WebsocketServerRecorder;
import jakarta.websocket.Decoder;
import jakarta.websocket.Encoder;
import jakarta.websocket.server.ServerEndpoint;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

public class ServerWebSocketProcessor {
    private static final DotName SERVER_ENDPOINT = DotName.createSimple((String)ServerEndpoint.class.getName());
    public static final Collection<DotName> CODECS = List.of(Decoder.TextStream.class, Decoder.Text.class, Decoder.BinaryStream.class, Decoder.Binary.class, Encoder.TextStream.class, Encoder.Text.class, Encoder.BinaryStream.class, Encoder.Binary.class).stream().map(Class::getName).map(DotName::createSimple).collect(Collectors.toList());

    @BuildStep
    void holdConfig(BuildProducer<FeatureBuildItem> feature) {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.WEBSOCKETS));
    }

    @BuildStep
    void scanForAnnotatedEndpoints(CombinedIndexBuildItem indexBuildItem, BuildProducer<AnnotatedWebsocketEndpointBuildItem> annotatedProducer) {
        IndexView index = indexBuildItem.getIndex();
        Collection serverEndpoints = index.getAnnotations(SERVER_ENDPOINT);
        for (AnnotationInstance endpoint : serverEndpoints) {
            ClassInfo clazz;
            if (!(endpoint.target() instanceof ClassInfo) || Modifier.isAbstract((clazz = (ClassInfo)endpoint.target()).flags())) continue;
            annotatedProducer.produce((BuildItem)new AnnotatedWebsocketEndpointBuildItem(clazz.name().toString(), false));
        }
    }

    @BuildStep
    void buildIndexDependencies(BuildProducer<IndexDependencyBuildItem> indexDependencyProduer) {
        indexDependencyProduer.produce((BuildItem)new IndexDependencyBuildItem("jakarta.websocket", "jakarta.websocket-client-api"));
    }

    @BuildStep
    void scanForCodecs(CombinedIndexBuildItem index, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchyBuildItemProducer) {
        CODECS.stream().forEach(codec -> index.getIndex().getAllKnownImplementors(codec).stream().filter(implementor -> !Modifier.isAbstract(implementor.flags())).forEach(implementor -> JandexUtil.resolveTypeParameters((DotName)implementor.name(), (DotName)codec, (IndexView)index.getIndex()).forEach(typeParameter -> reflectiveHierarchyBuildItemProducer.produce((BuildItem)ReflectiveHierarchyBuildItem.builder((Type)typeParameter).build()))));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public ServerWebSocketContainerFactoryBuildItem factory(WebsocketServerRecorder recorder) {
        return new ServerWebSocketContainerFactoryBuildItem(recorder.createFactory());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public FilterBuildItem deploy(CombinedIndexBuildItem indexBuildItem, WebsocketServerRecorder recorder, BuildProducer<ReflectiveClassBuildItem> reflection, Optional<WebSocketDeploymentInfoBuildItem> webSocketDeploymentInfoBuildItem, Optional<ServerWebSocketContainerBuildItem> serverWebSocketContainerBuildItem) throws Exception {
        if (webSocketDeploymentInfoBuildItem.isEmpty()) {
            return null;
        }
        IndexView index = indexBuildItem.getIndex();
        WebsocketClientProcessor.registerCodersForReflection(reflection, (Collection)index.getAnnotations(SERVER_ENDPOINT));
        int priority = 101;
        return new FilterBuildItem(recorder.createHandler(webSocketDeploymentInfoBuildItem.get().getInfo(), serverWebSocketContainerBuildItem.get().getContainer()), priority);
    }

    @BuildStep
    void beanDefiningAnnotations(BuildProducer<BeanDefiningAnnotationBuildItem> annotations) {
        annotations.produce((BuildItem)new BeanDefiningAnnotationBuildItem(SERVER_ENDPOINT));
    }
}

