/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.webdependency.locator.deployment.devui;

import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.vertx.http.runtime.VertxHttpBuildTimeConfig;
import io.quarkus.webdependency.locator.deployment.devui.WebDependencyAsset;
import io.quarkus.webdependency.locator.deployment.devui.WebDependencyLibrariesBuildItem;
import io.quarkus.webdependency.locator.deployment.devui.WebDependencyLibrary;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

public class WebDependencyLocatorDevModeApiProcessor {
    private static final String PREFIX = "META-INF/resources/";
    private static final String WEBJARS_PATH = "webjars";
    private static final String MVNPM_PATH = "_static";
    private static final Logger log = Logger.getLogger((String)WebDependencyLocatorDevModeApiProcessor.class.getName());

    @BuildStep(onlyIf={IsDevelopment.class})
    public void findWebDependenciesAssets(VertxHttpBuildTimeConfig httpBuildTimeConfig, CurateOutcomeBuildItem curateOutcome, BuildProducer<WebDependencyLibrariesBuildItem> webDependencyLibrariesProducer) {
        List<WebDependencyLibrary> webJarLibraries = this.getLibraries(httpBuildTimeConfig, curateOutcome, WEBJARS_PATH);
        webDependencyLibrariesProducer.produce((BuildItem)new WebDependencyLibrariesBuildItem(WEBJARS_PATH, webJarLibraries));
        List<WebDependencyLibrary> mvnpmLibraries = this.getLibraries(httpBuildTimeConfig, curateOutcome, MVNPM_PATH);
        webDependencyLibrariesProducer.produce((BuildItem)new WebDependencyLibrariesBuildItem("mvnpm", mvnpmLibraries));
    }

    private List<WebDependencyLibrary> getLibraries(VertxHttpBuildTimeConfig httpBuildTimeConfig, CurateOutcomeBuildItem curateOutcome, String path) {
        Map webDependencyKeys;
        ArrayList<WebDependencyLibrary> webDependencyLibraries = new ArrayList<WebDependencyLibrary>();
        List providers = QuarkusClassLoader.getElements((String)(PREFIX + path), (boolean)false);
        if (!providers.isEmpty() && !(webDependencyKeys = (Map)providers.stream().filter(provider -> provider.getDependencyKey() != null && provider.isRuntime()).collect(Collectors.toMap(ClassPathElement::getDependencyKey, provider -> provider, (a, b) -> b, () -> new HashMap(providers.size())))).isEmpty()) {
            String rootPath = httpBuildTimeConfig.rootPath();
            String webDependencyRootPath = rootPath.endsWith("/") ? rootPath + path + "/" : rootPath + "/" + path + "/";
            curateOutcome.getApplicationModel().getDependencies().stream().map(dep -> this.createWebDependencyLibrary((ResolvedDependency)dep, webDependencyRootPath, webDependencyKeys, path)).filter(Objects::nonNull).forEach(webDependencyLibraries::add);
        }
        return webDependencyLibraries;
    }

    private WebDependencyLibrary createWebDependencyLibrary(ResolvedDependency dep, String webDependencyRootPath, Map<ArtifactKey, ClassPathElement> webDependencyKeys, String path) {
        if (!dep.isRuntimeCp()) {
            return null;
        }
        ClassPathElement provider = webDependencyKeys.get(dep.getKey());
        if (provider == null) {
            return null;
        }
        WebDependencyLibrary webDependencyLibrary = new WebDependencyLibrary(provider.getDependencyKey().getArtifactId());
        provider.apply(tree -> {
            Path nameDir;
            Path webDependenciesDir = tree.getPath(PREFIX + path);
            try (Stream<Path> webDependenciesDirPaths = Files.list(webDependenciesDir);){
                nameDir = webDependenciesDirPaths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).findFirst().orElseThrow(() -> new IOException("Could not find name directory for " + dep.getKey().getArtifactId() + " in " + String.valueOf(webDependenciesDir)));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            Path root = nameDir;
            StringBuilder urlBase = new StringBuilder(webDependencyRootPath);
            boolean appendRootPart = true;
            try {
                Path versionDir = nameDir.resolve(dep.getVersion());
                root = Files.isDirectory(versionDir, new LinkOption[0]) ? versionDir : nameDir;
                urlBase.append(nameDir.getFileName().toString()).append("/");
                appendRootPart = false;
            }
            catch (InvalidPathException e) {
                log.warn((Object)("Could not find version directory for " + dep.getKey().getArtifactId() + " " + dep.getVersion() + " in " + String.valueOf(nameDir) + ", falling back to name directory"));
            }
            webDependencyLibrary.setVersion(dep.getVersion());
            try {
                WebDependencyAsset asset = this.createAssetForLibrary(root, urlBase.toString(), appendRootPart);
                webDependencyLibrary.setRootAsset(asset);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return null;
        });
        return webDependencyLibrary;
    }

    private WebDependencyAsset createAssetForLibrary(Path rootPath, String urlBase, boolean appendRootPart) throws IOException {
        WebDependencyAsset root = new WebDependencyAsset();
        root.setName(rootPath.getFileName().toString());
        root.setChildren(new LinkedList<WebDependencyAsset>());
        root.setFileAsset(false);
        urlBase = appendRootPart ? urlBase + root.getName() + "/" : urlBase;
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(rootPath);){
            for (Path childPath : directoryStream) {
                if (Files.isDirectory(childPath, new LinkOption[0])) {
                    WebDependencyAsset childDir = this.createAssetForLibrary(childPath, urlBase, true);
                    root.getChildren().add(childDir);
                    continue;
                }
                WebDependencyAsset childFile = new WebDependencyAsset();
                childFile.setName(childPath.getFileName().toString());
                childFile.setFileAsset(true);
                childFile.setUrlPart(urlBase + childFile.getName());
                root.getChildren().add(childFile);
            }
        }
        root.getChildren().sort(Comparator.comparing(WebDependencyAsset::getName));
        return root;
    }
}

