/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.deployment.menu;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.devui.deployment.InternalPageBuildItem;
import io.quarkus.devui.runtime.readme.ReadmeJsonRPCService;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;

public class ReadmeProcessor {
    private static final String NS = "devui-readme";

    @BuildStep(onlyIf={IsDevelopment.class})
    void createReadmePage(BuildProducer<InternalPageBuildItem> internalPageProducer) {
        String readme = this.getContents("README.md").orElse(this.getContents("readme.md").orElse(null));
        if (readme != null) {
            InternalPageBuildItem readmePage = new InternalPageBuildItem("Readme", 51);
            readmePage.addBuildTimeData("readme", readme);
            readmePage.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().namespace(NS)).title("Readme")).icon("font-awesome-brands:readme")).componentLink("qwc-readme.js"));
            internalPageProducer.produce((BuildItem)readmePage);
        }
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    JsonRPCProvidersBuildItem createJsonRPCServiceForCache() {
        return new JsonRPCProvidersBuildItem(NS, ReadmeJsonRPCService.class);
    }

    private Optional<String> getContents(String name) {
        Path p = Path.of(name, new String[0]);
        if (Files.exists(p, new LinkOption[0])) {
            try {
                return Optional.of(Files.readString(p));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return Optional.empty();
    }
}

