/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment;

import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.util.UriNormalizationUtil;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.quarkus.vertx.http.deployment.devmode.console.ConfiguredPathInfo;
import io.quarkus.vertx.http.runtime.HandlerType;
import io.quarkus.vertx.http.runtime.management.ManagementInterfaceBuildTimeConfig;
import io.vertx.core.Handler;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.net.URI;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public final class NonApplicationRootPathBuildItem
extends SimpleBuildItem {
    final URI httpRootPath;
    final URI nonApplicationRootPath;
    final URI managementRootPath;
    final boolean dedicatedRouterRequired;
    final boolean attachedToMainRouter;

    public NonApplicationRootPathBuildItem(String httpRootPath, String nonApplicationRootPath, String managementRootPath) {
        this.httpRootPath = UriNormalizationUtil.toURI((String)httpRootPath, (boolean)true);
        this.nonApplicationRootPath = UriNormalizationUtil.normalizeWithBase((URI)this.httpRootPath, (String)nonApplicationRootPath, (boolean)true);
        this.managementRootPath = managementRootPath == null ? null : UriNormalizationUtil.toURI((String)("/" + managementRootPath), (boolean)true);
        this.dedicatedRouterRequired = !this.nonApplicationRootPath.getPath().equals(this.httpRootPath.getPath());
        this.attachedToMainRouter = this.nonApplicationRootPath.getPath().startsWith(this.httpRootPath.getPath());
    }

    public boolean isDedicatedRouterRequired() {
        return this.dedicatedRouterRequired;
    }

    public boolean isAttachedToMainRouter() {
        return this.attachedToMainRouter;
    }

    String getVertxRouterPath() {
        if (this.attachedToMainRouter) {
            return "/" + UriNormalizationUtil.relativize((String)this.httpRootPath.getPath(), (String)this.nonApplicationRootPath.getPath());
        }
        return this.getNonApplicationRootPath();
    }

    public String getNormalizedHttpRootPath() {
        return this.httpRootPath.getPath();
    }

    public String getNonApplicationRootPath() {
        return this.nonApplicationRootPath.getPath();
    }

    public String getManagementRootPath() {
        if (this.managementRootPath != null) {
            return this.managementRootPath.getPath();
        }
        return this.getNonApplicationRootPath();
    }

    public String resolvePath(String path) {
        if (path == null || path.trim().isEmpty()) {
            throw new IllegalArgumentException("Specified path can not be empty");
        }
        return UriNormalizationUtil.normalizeWithBase((URI)this.nonApplicationRootPath, (String)path, (boolean)false).getPath();
    }

    public String resolveManagementPath(String path, ManagementInterfaceBuildTimeConfig managementInterfaceBuildTimeConfig, LaunchModeBuildItem mode) {
        if (path == null || path.trim().isEmpty()) {
            throw new IllegalArgumentException("Specified path can not be empty");
        }
        if (!managementInterfaceBuildTimeConfig.enabled) {
            if (this.managementRootPath != null) {
                return UriNormalizationUtil.normalizeWithBase((URI)this.managementRootPath, (String)path, (boolean)false).getPath();
            }
            return UriNormalizationUtil.normalizeWithBase((URI)this.nonApplicationRootPath, (String)path, (boolean)false).getPath();
        }
        String prefix = NonApplicationRootPathBuildItem.getManagementUrlPrefix(mode);
        if (this.managementRootPath != null) {
            return prefix + UriNormalizationUtil.normalizeWithBase((URI)this.managementRootPath, (String)path, (boolean)false).getPath();
        }
        return prefix + path;
    }

    public static String getManagementUrlPrefix(LaunchModeBuildItem mode) {
        boolean isHttps;
        Config config = ConfigProvider.getConfig();
        String managementHost = config.getOptionalValue("quarkus.management.host", String.class).orElse("0.0.0.0");
        Integer managementPort = config.getOptionalValue("quarkus.management.port", Integer.class).orElse(9000);
        if (mode.isTest()) {
            managementPort = config.getOptionalValue("quarkus.management.test-port", Integer.class).orElse(9001);
        }
        return ((isHttps = NonApplicationRootPathBuildItem.isTLsConfigured(config)) ? "https://" : "http://") + managementHost + ":" + managementPort;
    }

    public String resolveNestedPath(String path, String subRoute) {
        if (path == null || path.trim().isEmpty()) {
            throw new IllegalArgumentException("Specified path can not be empty");
        }
        URI base = UriNormalizationUtil.normalizeWithBase((URI)this.nonApplicationRootPath, (String)path, (boolean)true);
        return UriNormalizationUtil.normalizeWithBase((URI)base, (String)subRoute, (boolean)false).getPath();
    }

    public String resolveManagementNestedPath(String path, String subRoute) {
        if (path == null || path.trim().isEmpty()) {
            throw new IllegalArgumentException("Specified path can not be empty");
        }
        URI base = this.managementRootPath != null ? UriNormalizationUtil.normalizeWithBase((URI)this.managementRootPath, (String)path, (boolean)true) : UriNormalizationUtil.normalizeWithBase((URI)this.nonApplicationRootPath, (String)path, (boolean)true);
        return UriNormalizationUtil.normalizeWithBase((URI)base, (String)subRoute, (boolean)false).getPath();
    }

    public Builder routeBuilder() {
        return new Builder(this);
    }

    private static boolean isTLsConfigured(Config config) {
        boolean hasCert = config.getOptionalValue("quarkus.management.ssl.certificate.file", String.class).isPresent();
        boolean hasKey = config.getOptionalValue("quarkus.management.ssl.certificate.key-file", String.class).isPresent();
        boolean hasKeys = config.getOptionalValue("quarkus.management.ssl.certificate.key-files", String.class).isPresent();
        boolean hasCerts = config.getOptionalValue("quarkus.management.ssl.certificate.files", String.class).isPresent();
        boolean hasProvider = config.getOptionalValue("quarkus.management.ssl.certificate.credential-provider", String.class).isPresent();
        boolean hasProviderName = config.getOptionalValue("quarkus.management.ssl.certificate.credential-provider-name", String.class).isPresent();
        boolean hasKeyStore = config.getOptionalValue("quarkus.management.ssl.certificate.key-store-file", String.class).isPresent();
        return hasCerts || hasKeys || hasCert || hasKey || hasProvider || hasProviderName || hasKeyStore;
    }

    public static class Builder
    extends RouteBuildItem.Builder {
        private final NonApplicationRootPathBuildItem buildItem;
        private RouteBuildItem.RouteType routeType = RouteBuildItem.RouteType.FRAMEWORK_ROUTE;
        private RouteBuildItem.RouteType routerType = RouteBuildItem.RouteType.FRAMEWORK_ROUTE;
        private String path;

        Builder(NonApplicationRootPathBuildItem buildItem) {
            this.buildItem = buildItem;
        }

        @Override
        public Builder routeFunction(Function<Router, Route> routeFunction) {
            throw new RuntimeException("This method is not supported using this builder. Use #routeFunction(String, Consumer<Route>)");
        }

        @Override
        public Builder routeFunction(String route, Consumer<Route> routeFunction) {
            boolean isFrameworkRoute;
            if (this.isManagement && this.buildItem.managementRootPath != null) {
                this.path = route.startsWith("/") ? route : this.buildItem.getManagementRootPath() + route;
                this.routerType = RouteBuildItem.RouteType.ABSOLUTE_ROUTE;
                super.routeFunction(this.path, routeFunction);
                return this;
            }
            route = this.absolutePath = this.buildItem.resolvePath(route);
            boolean bl = isFrameworkRoute = this.buildItem.dedicatedRouterRequired && route.startsWith(this.buildItem.getNonApplicationRootPath());
            if (isFrameworkRoute) {
                this.path = "/" + UriNormalizationUtil.relativize((String)this.buildItem.getNonApplicationRootPath(), (String)route);
                this.routerType = RouteBuildItem.RouteType.FRAMEWORK_ROUTE;
            } else if (route.startsWith(this.buildItem.httpRootPath.getPath())) {
                this.path = "/" + UriNormalizationUtil.relativize((String)this.buildItem.httpRootPath.getPath(), (String)route);
                this.routerType = RouteBuildItem.RouteType.APPLICATION_ROUTE;
            } else if (route.startsWith("/")) {
                this.path = route;
                this.routerType = RouteBuildItem.RouteType.ABSOLUTE_ROUTE;
            }
            super.routeFunction(this.path, routeFunction);
            return this;
        }

        @Override
        public Builder route(String route) {
            this.routeFunction(route, (Consumer)null);
            return this;
        }

        public Builder nestedRoute(String baseRoute, String subRoute) {
            if (subRoute.startsWith("/")) {
                this.routeFunction(subRoute, (Consumer)null);
                return this;
            }
            baseRoute = ((String)baseRoute).endsWith("/") ? baseRoute : (String)baseRoute + "/";
            this.routeFunction((String)baseRoute + subRoute, (Consumer)null);
            return this;
        }

        @Override
        public Builder handler(Handler<RoutingContext> handler) {
            super.handler(handler);
            return this;
        }

        @Override
        public Builder handlerType(HandlerType handlerType) {
            super.handlerType(handlerType);
            return this;
        }

        @Override
        public Builder blockingRoute() {
            super.blockingRoute();
            return this;
        }

        @Override
        public Builder failureRoute() {
            super.failureRoute();
            return this;
        }

        @Override
        public Builder displayOnNotFoundPage() {
            super.displayOnNotFoundPage();
            return this;
        }

        @Override
        public Builder displayOnNotFoundPage(String notFoundPageTitle) {
            super.displayOnNotFoundPage(notFoundPageTitle);
            return this;
        }

        @Override
        public Builder routeConfigKey(String attributeName) {
            super.routeConfigKey(attributeName);
            return this;
        }

        @Override
        public RouteBuildItem build() {
            return new RouteBuildItem(this, this.routeType, this.routerType, this.isManagement);
        }

        @Override
        protected ConfiguredPathInfo getRouteConfigInfo() {
            return super.getRouteConfigInfo();
        }

        @Override
        protected NotFoundPageDisplayableEndpointBuildItem getNotFoundEndpoint() {
            if (!this.displayOnNotFoundPage) {
                return null;
            }
            if (this.isManagement && this.buildItem.managementRootPath != null) {
                return null;
            }
            if (this.notFoundPagePath == null) {
                throw new RuntimeException("Cannot display " + this.routeFunction + " on not found page as no explicit path was specified and a route function is in use");
            }
            if (this.absolutePath != null) {
                return new NotFoundPageDisplayableEndpointBuildItem(this.absolutePath, this.notFoundPageTitle, true);
            }
            return new NotFoundPageDisplayableEndpointBuildItem(this.notFoundPagePath, this.notFoundPageTitle, false);
        }

        @Override
        public Builder management() {
            super.management();
            return this;
        }
    }
}

