/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment.devmode.console;

import io.quarkus.deployment.ide.Ide;
import io.quarkus.devconsole.runtime.spi.DevConsolePostHandler;
import io.vertx.core.MultiMap;
import io.vertx.ext.web.RoutingContext;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;

public class OpenIdeHandler
extends DevConsolePostHandler {
    private static final Logger log = Logger.getLogger(OpenIdeHandler.class);
    private static final Map<String, String> LANG_TO_EXT = new HashMap<String, String>();
    private final Ide ide;

    public OpenIdeHandler(Ide ide) {
        this.ide = ide;
    }

    protected void dispatch(RoutingContext routingContext, MultiMap form) {
        String className = form.get("className");
        String lang = form.get("lang");
        String srcMainPath = form.get("srcMainPath");
        String line = form.get("line");
        if (this.isNullOrEmpty(className) || this.isNullOrEmpty(lang) || this.isNullOrEmpty(srcMainPath)) {
            routingContext.fail(400);
        }
        if (this.ide != null) {
            this.typicalProcessLaunch(routingContext, className, lang, srcMainPath, line, this.ide.getExecutable());
        } else {
            log.debug((Object)("Unhandled IDE : " + this.ide));
            routingContext.fail(500);
        }
    }

    private void typicalProcessLaunch(RoutingContext routingContext, String className, String lang, String srcMainPath, String line, String binary) {
        String arg = this.toFileName(className, lang, srcMainPath);
        if (!this.isNullOrEmpty(line)) {
            arg = arg + ":" + line;
        }
        this.launchInIDE(Arrays.asList(binary, arg), routingContext);
    }

    private String toFileName(String className, String lang, String srcMainPath) {
        return srcMainPath + File.separator + lang + File.separator + className.replace('.', File.separatorChar) + "." + LANG_TO_EXT.get(lang);
    }

    protected void launchInIDE(final List<String> command, final RoutingContext routingContext) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    new ProcessBuilder(command).inheritIO().start().waitFor(10L, TimeUnit.SECONDS);
                    routingContext.response().setStatusCode(200).end();
                }
                catch (Exception e) {
                    routingContext.fail((Throwable)e);
                }
            }
        }, "Launch in IDE Action").start();
    }

    private boolean isNullOrEmpty(String arg) {
        return arg == null || arg.isEmpty();
    }

    static {
        LANG_TO_EXT.put("java", "java");
        LANG_TO_EXT.put("kotlin", "kt");
    }
}

