/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.security;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.test.security.AbstractTestHttpAuthenticationMechanism;
import io.smallrye.mutiny.Uni;
import io.vertx.core.http.Cookie;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class PathBasedTestHttpAuthenticationMechanism
extends AbstractTestHttpAuthenticationMechanism {
    @Override
    public Uni<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager) {
        if (this.authMechanism != null && PathBasedTestHttpAuthenticationMechanism.requestNotAuthenticated(context)) {
            return super.authenticate(context, identityProviderManager);
        }
        return Uni.createFrom().nullItem();
    }

    public int getPriority() {
        return 3000;
    }

    private static boolean requestNotAuthenticated(RoutingContext context) {
        return context.request().getHeader((CharSequence)HttpHeaderNames.AUTHORIZATION) == null && !PathBasedTestHttpAuthenticationMechanism.hasOidcSessionCookieCandidate(context);
    }

    private static boolean hasOidcSessionCookieCandidate(RoutingContext context) {
        if (context.request().cookies() == null) {
            return false;
        }
        for (Cookie cookie : context.request().cookies()) {
            if (cookie.getName() == null || !cookie.getName().startsWith("q_session")) continue;
            return true;
        }
        return false;
    }
}

