/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import io.restassured.RestAssured;
import io.restassured.config.HttpClientConfig;
import io.restassured.config.RestAssuredConfig;
import io.restassured.specification.RequestSpecification;
import java.time.Duration;
import java.util.Optional;
import org.eclipse.microprofile.config.ConfigProvider;

public class RestAssuredURLManager {
    private static final int DEFAULT_HTTP_PORT = 8081;
    private static final int DEFAULT_HTTPS_PORT = 8444;
    private static int oldPort;
    private static String oldBaseURI;
    private static String oldBasePath;
    private static Object oldRestAssuredConfig;
    private static Object oldRequestSpecification;
    private static final boolean REST_ASSURED_PRESENT;

    private RestAssuredURLManager() {
    }

    private static int getPortFromConfig(int defaultValue, String ... keys) {
        for (String key : keys) {
            Optional port = ConfigProvider.getConfig().getOptionalValue(key, Integer.class);
            if (!port.isPresent()) continue;
            return (Integer)port.get();
        }
        return defaultValue;
    }

    public static void setURL(boolean useSecureConnection) {
        RestAssuredURLManager.setURL(useSecureConnection, null, null);
    }

    public static void setURL(boolean useSecureConnection, String additionalPath) {
        RestAssuredURLManager.setURL(useSecureConnection, null, additionalPath);
    }

    public static void setURL(boolean useSecureConnection, Integer port) {
        RestAssuredURLManager.setURL(useSecureConnection, port, null);
    }

    public static void setURL(boolean useSecureConnection, Integer port, String additionalPath) {
        if (!REST_ASSURED_PRESENT) {
            return;
        }
        oldPort = RestAssured.port;
        if (port == null) {
            port = useSecureConnection ? RestAssuredURLManager.getPortFromConfig(8444, "quarkus.http.test-ssl-port") : RestAssuredURLManager.getPortFromConfig(8081, "quarkus.lambda.mock-event-server.test-port", "quarkus.http.test-port");
        }
        RestAssured.port = port;
        oldBaseURI = RestAssured.baseURI;
        String protocol = useSecureConnection ? "https://" : "http://";
        String host = ConfigProvider.getConfig().getOptionalValue("quarkus.http.host", String.class).orElse("localhost");
        if (host.equals("0.0.0.0")) {
            host = "localhost";
        }
        RestAssured.baseURI = protocol + host;
        oldBasePath = RestAssured.basePath;
        Optional basePath = ConfigProvider.getConfig().getOptionalValue("quarkus.http.root-path", String.class);
        if (basePath.isPresent() || additionalPath != null) {
            StringBuilder bp = new StringBuilder();
            if (basePath.isPresent()) {
                if (((String)basePath.get()).startsWith("/")) {
                    bp.append(((String)basePath.get()).substring(1));
                } else {
                    bp.append((String)basePath.get());
                }
                if (bp.toString().endsWith("/")) {
                    bp.setLength(bp.length() - 1);
                }
            }
            if (additionalPath != null) {
                if (!additionalPath.startsWith("/")) {
                    bp.append("/");
                }
                bp.append(additionalPath);
                if (bp.toString().endsWith("/")) {
                    bp.setLength(bp.length() - 1);
                }
            }
            RestAssured.basePath = bp.toString();
        }
        oldRestAssuredConfig = RestAssured.config();
        Duration timeout = ConfigProvider.getConfig().getOptionalValue("quarkus.http.test-timeout", Duration.class).orElse(Duration.ofSeconds(30L));
        RestAssuredURLManager.configureTimeouts(timeout);
        oldRequestSpecification = RestAssured.requestSpecification;
        if (ConfigProvider.getConfig().getOptionalValue("quarkus.test.rest-assured.enable-logging-on-failure", Boolean.class).orElse(true).booleanValue()) {
            RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
        }
    }

    private static void configureTimeouts(Duration d) {
        RestAssured.config = RestAssured.config().httpClient(new HttpClientConfig().setParam("http.conn-manager.timeout", (Object)d.toMillis()).setParam("http.connection.timeout", (Object)((int)d.toMillis())).setParam("http.socket.timeout", (Object)((int)d.toMillis())));
    }

    public static void clearURL() {
        if (!REST_ASSURED_PRESENT) {
            return;
        }
        RestAssured.port = oldPort;
        RestAssured.baseURI = oldBaseURI;
        RestAssured.basePath = oldBasePath;
        RestAssured.config = (RestAssuredConfig)oldRestAssuredConfig;
        RestAssured.requestSpecification = (RequestSpecification)oldRequestSpecification;
    }

    static {
        boolean present = false;
        try {
            Class.forName("io.restassured.RestAssured");
            present = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        REST_ASSURED_PRESENT = present;
    }
}

