/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.test;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.amazon.lambda.runtime.FunctionError;
import io.quarkus.amazon.lambda.test.LambdaClient;
import io.quarkus.amazon.lambda.test.LambdaException;
import io.quarkus.amazon.lambda.test.LambdaStartedNotifier;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.RoutingHandler;
import io.undertow.server.handlers.BlockingHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class LambdaResourceManager
implements QuarkusTestResourceLifecycleManager {
    private volatile boolean started = false;
    private volatile Undertow undertow;
    private final AtomicInteger currentPollCount = new AtomicInteger();
    public static final int PORT = Integer.getInteger("quarkus-internal.aws-lambda.test-port", 5387);

    public Map<String, String> start() {
        this.started = true;
        RoutingHandler routingHandler = new RoutingHandler(true);
        routingHandler.add("GET", "/2018-06-01/runtime/invocation/next", new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                LambdaResourceManager.this.currentPollCount.incrementAndGet();
                try {
                    LambdaStartedNotifier.started = true;
                    Map.Entry<String, String> req = null;
                    while (req == null) {
                        req = LambdaClient.REQUEST_QUEUE.poll(100L, TimeUnit.MILLISECONDS);
                        if (LambdaResourceManager.this.started && LambdaResourceManager.this.undertow != null && LambdaResourceManager.this.undertow.getWorker() != null && !LambdaResourceManager.this.undertow.getWorker().isShutdown()) continue;
                        exchange.setStatusCode(503);
                        exchange.setPersistent(false);
                        exchange.getOutputStream().close();
                        return;
                    }
                    exchange.addResponseHeader("Lambda-Runtime-Aws-Request-Id", (String)req.getKey());
                    exchange.getOutputStream().write(req.getValue().getBytes(StandardCharsets.UTF_8));
                    exchange.getOutputStream().close();
                }
                finally {
                    LambdaResourceManager.this.currentPollCount.decrementAndGet();
                }
            }
        });
        routingHandler.add("POST", "/2018-06-01/runtime/invocation/{req}/response", new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                int r;
                String id = (String)((Deque)exchange.getQueryParameters().get("req")).getFirst();
                byte[] data = new byte[1024];
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                while ((r = exchange.getInputStream().read(data)) > 0) {
                    bao.write(data, 0, r);
                }
                LambdaClient.REQUESTS.get(id).complete(new String(bao.toByteArray(), StandardCharsets.UTF_8));
            }
        });
        routingHandler.add("POST", "/2018-06-01/runtime/invocation/{req}/error", new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                int r;
                String id = (String)((Deque)exchange.getQueryParameters().get("req")).getFirst();
                byte[] data = new byte[1024];
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                while ((r = exchange.getInputStream().read(data)) > 0) {
                    bao.write(data, 0, r);
                }
                String body = new String(bao.toByteArray(), StandardCharsets.UTF_8);
                ObjectMapper mapper = new ObjectMapper();
                try {
                    FunctionError result = (FunctionError)mapper.readerFor(FunctionError.class).readValue(body);
                    LambdaClient.REQUESTS.get(id).completeExceptionally(new LambdaException(result.getErrorType(), result.getErrorMessage()));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        routingHandler.add("POST", "/2018-06-01/runtime/init/error", new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                int r;
                byte[] data = new byte[1024];
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                while ((r = exchange.getInputStream().read(data)) > 0) {
                    bao.write(data, 0, r);
                }
                String body = new String(bao.toByteArray(), StandardCharsets.UTF_8);
                ObjectMapper mapper = new ObjectMapper();
                try {
                    FunctionError result = (FunctionError)mapper.readerFor(FunctionError.class).readValue(body);
                    LambdaClient.problem = new LambdaException(result.getErrorType(), result.getErrorMessage());
                    LambdaStartedNotifier.started = true;
                    for (Map.Entry<String, CompletableFuture<String>> e : LambdaClient.REQUESTS.entrySet()) {
                        e.getValue().completeExceptionally(LambdaClient.problem);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.undertow = Undertow.builder().addHttpListener(PORT, "localhost").setHandler((HttpHandler)new BlockingHandler((HttpHandler)routingHandler)).build();
        this.undertow.start();
        System.setProperty("quarkus-internal.aws-lambda.test-api", "localhost:" + PORT);
        return Collections.singletonMap("quarkus-internal.aws-lambda.test-api", "localhost:" + PORT);
    }

    public void stop() {
        this.started = false;
        while (this.currentPollCount.get() > 0) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.undertow == null) {
            return;
        }
        this.undertow.stop();
        this.undertow = null;
    }
}

