/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.runtime;

import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.smallrye.openapi.runtime.OpenApiConstants;
import io.quarkus.smallrye.openapi.runtime.OpenApiHandler;
import io.quarkus.smallrye.openapi.runtime.OpenApiNotFoundHandler;
import io.quarkus.smallrye.openapi.runtime.OpenApiRuntimeConfig;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.quarkus.vertx.http.runtime.filters.Filter;
import io.vertx.core.Handler;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.spi.OASFactoryResolver;
import org.jboss.logging.Logger;

@Recorder
public class OpenApiRecorder {
    private static final Logger log = Logger.getLogger(OpenApiRecorder.class);
    final RuntimeValue<HttpConfiguration> configuration;

    public OpenApiRecorder(RuntimeValue<HttpConfiguration> configuration) {
        this.configuration = configuration;
    }

    public Consumer<Route> corsFilter(final Filter filter) {
        if (((HttpConfiguration)this.configuration.getValue()).corsEnabled && filter.getHandler() != null) {
            return new Consumer<Route>(){

                @Override
                public void accept(Route route) {
                    route.order(-1 * filter.getPriority()).handler(filter.getHandler());
                }
            };
        }
        return null;
    }

    public Handler<RoutingContext> handler(OpenApiRuntimeConfig runtimeConfig) {
        if (runtimeConfig.enable) {
            return new OpenApiHandler();
        }
        return new OpenApiNotFoundHandler();
    }

    public void setupClDevMode(ShutdownContext shutdownContext) {
        OpenApiConstants.classLoader = Thread.currentThread().getContextClassLoader();
        shutdownContext.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                OpenApiConstants.classLoader = null;
            }
        });
    }

    public void classLoaderHack() {
        final ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(new ClassLoader(null){

                @Override
                public Class<?> loadClass(String name) throws ClassNotFoundException {
                    return cl.loadClass(name);
                }

                @Override
                protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                    return cl.loadClass(name);
                }

                @Override
                public URL getResource(String name) {
                    return cl.getResource(name);
                }

                @Override
                public Enumeration<URL> getResources(String name) throws IOException {
                    return cl.getResources(name);
                }

                @Override
                public InputStream getResourceAsStream(String name) {
                    return cl.getResourceAsStream(name);
                }
            });
            OASFactoryResolver.instance();
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public Supplier<OASFilter> autoSecurityFilterSupplier(final OASFilter autoSecurityFilter) {
        return new Supplier<OASFilter>(){

            @Override
            public OASFilter get() {
                return autoSecurityFilter;
            }
        };
    }

    public Supplier<?> createUserDefinedRuntimeFilters(final List<String> filters) {
        return new Supplier<Object>(){

            @Override
            public UserDefinedRuntimeFilters get() {
                return new UserDefinedRuntimeFilters(){

                    @Override
                    public List<String> filters() {
                        return filters;
                    }
                };
            }
        };
    }

    public static interface UserDefinedRuntimeFilters {
        public List<String> filters();
    }
}

