/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.deployment.filter;

import io.smallrye.openapi.api.models.servers.ServerImpl;
import java.util.ArrayList;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.OpenAPI;

public class AutoServerFilter
implements OASFilter {
    private static final String HTTP = "http";
    private static final String ZEROS = "0.0.0.0";
    private static final String LOCALHOST = "localhost";
    private static final String URL_PATTERN = "%s://%s:%d";
    private final String defaultScheme;
    private final String defaultHost;
    private final int defaultPort;
    private final String description;

    public AutoServerFilter(String defaultScheme, String defaultHost, int defaultPort, String description) {
        if (defaultScheme == null) {
            defaultScheme = HTTP;
        }
        if (defaultHost == null) {
            defaultHost = ZEROS;
        }
        this.defaultScheme = defaultScheme;
        this.defaultHost = defaultHost;
        this.defaultPort = defaultPort;
        this.description = description;
    }

    public void filterOpenAPI(OpenAPI openAPI) {
        ArrayList<ServerImpl> servers = openAPI.getServers();
        if (servers == null || servers.isEmpty()) {
            servers = new ArrayList<ServerImpl>();
            if (this.defaultHost.equals(ZEROS)) {
                ServerImpl localhost = new ServerImpl();
                localhost.setUrl(this.getUrl(this.defaultScheme, LOCALHOST, this.defaultPort));
                localhost.setDescription(this.description);
                servers.add(localhost);
            }
            ServerImpl serverImpl = new ServerImpl();
            serverImpl.setUrl(this.getUrl(this.defaultScheme, this.defaultHost, this.defaultPort));
            serverImpl.setDescription(this.description);
            servers.add(serverImpl);
            openAPI.setServers(servers);
        }
    }

    private String getUrl(String scheme, String host, int port) {
        return String.format(URL_PATTERN, scheme, host, port);
    }
}

