/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.webauthn.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.security.webauthn.WebAuthn;
import io.quarkus.security.webauthn.WebAuthnAuthenticationMechanism;
import io.quarkus.security.webauthn.WebAuthnAuthenticatorStorage;
import io.quarkus.security.webauthn.WebAuthnBuildTimeConfig;
import io.quarkus.security.webauthn.WebAuthnIdentityProvider;
import io.quarkus.security.webauthn.WebAuthnRecorder;
import io.quarkus.security.webauthn.WebAuthnSecurity;
import io.quarkus.security.webauthn.WebAuthnTrustedIdentityProvider;
import io.quarkus.vertx.http.deployment.HttpAuthMechanismAnnotationBuildItem;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.VertxWebRouterBuildItem;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.vertx.ext.auth.webauthn.impl.attestation.Attestation;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.function.BooleanSupplier;
import org.jboss.jandex.DotName;

@BuildSteps(onlyIf={IsEnabled.class})
class QuarkusSecurityWebAuthnProcessor {
    QuarkusSecurityWebAuthnProcessor() {
    }

    @BuildStep
    public void myBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        AdditionalBeanBuildItem.Builder builder = AdditionalBeanBuildItem.builder().setUnremovable();
        builder.addBeanClass(WebAuthnSecurity.class).addBeanClass(WebAuthnAuthenticatorStorage.class).addBeanClass(WebAuthnIdentityProvider.class).addBeanClass(WebAuthnTrustedIdentityProvider.class);
        additionalBeans.produce((BuildItem)builder.build());
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    public void setup(WebAuthnRecorder recorder, VertxWebRouterBuildItem vertxWebRouterBuildItem, BeanContainerBuildItem beanContainerBuildItem, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem) {
        recorder.setupRoutes(beanContainerBuildItem.getValue(), vertxWebRouterBuildItem.getHttpRouter(), nonApplicationRootPathBuildItem.getNonApplicationRootPath());
    }

    @BuildStep
    public ServiceProviderBuildItem serviceLoader() {
        return ServiceProviderBuildItem.allProvidersFromClassPath((String)Attestation.class.getName());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    SyntheticBeanBuildItem initWebAuthnAuth(WebAuthnRecorder recorder) {
        return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(WebAuthnAuthenticationMechanism.class).types(new Class[]{HttpAuthenticationMechanism.class})).setRuntimeInit().scope(Singleton.class)).supplier(recorder.setupWebAuthnAuthenticationMechanism()).done();
    }

    @BuildStep
    List<HttpAuthMechanismAnnotationBuildItem> registerHttpAuthMechanismAnnotation() {
        return List.of(new HttpAuthMechanismAnnotationBuildItem(DotName.createSimple(WebAuthn.class), "webauthn"));
    }

    public static class IsEnabled
    implements BooleanSupplier {
        WebAuthnBuildTimeConfig config;

        @Override
        public boolean getAsBoolean() {
            return this.config.enabled();
        }
    }
}

