/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.deployment;

import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.security.spi.SecurityTransformerUtils;
import java.util.List;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;

public class DenyingUnannotatedTransformer
implements AnnotationsTransformer {
    public boolean appliesTo(AnnotationTarget.Kind kind) {
        return kind == AnnotationTarget.Kind.CLASS;
    }

    public void transform(AnnotationsTransformer.TransformationContext transformationContext) {
        ClassInfo classInfo = transformationContext.getTarget().asClass();
        List methods = classInfo.methods();
        if (!SecurityTransformerUtils.hasSecurityAnnotation((ClassInfo)classInfo) && methods.stream().anyMatch(SecurityTransformerUtils::hasSecurityAnnotation)) {
            transformationContext.transform().add(SecurityTransformerUtils.DENY_ALL, new AnnotationValue[0]).done();
        }
    }
}

