/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.deployment;

import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.security.deployment.SecurityProcessor;
import io.quarkus.security.spi.SecurityTransformerUtils;
import io.quarkus.security.spi.runtime.MethodDescription;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;

public class AdditionalDenyingUnannotatedTransformer
implements AnnotationsTransformer {
    private final Set<MethodDescription> methods;

    public AdditionalDenyingUnannotatedTransformer(Collection<MethodDescription> methods) {
        this.methods = new HashSet<MethodDescription>(methods);
    }

    public boolean appliesTo(AnnotationTarget.Kind kind) {
        return kind == AnnotationTarget.Kind.METHOD;
    }

    public void transform(AnnotationsTransformer.TransformationContext context) {
        MethodDescription methodDescription = SecurityProcessor.createMethodDescription(context.getTarget().asMethod());
        if (this.methods.contains(methodDescription)) {
            context.transform().add(SecurityTransformerUtils.DENY_ALL, new AnnotationValue[0]).done();
        }
    }
}

