/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.deployment;

import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.security.deployment.SecurityTransformerUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;

public class AdditionalRolesAllowedTransformer
implements AnnotationsTransformer {
    private final Set<String> classNames;
    private final AnnotationValue[] rolesAllowed;

    public AdditionalRolesAllowedTransformer(Collection<String> classNames, List<String> rolesAllowed) {
        this.classNames = new HashSet<String>(classNames);
        this.rolesAllowed = (AnnotationValue[])rolesAllowed.stream().map(s -> AnnotationValue.createStringValue((String)"", (String)s)).toArray(AnnotationValue[]::new);
    }

    public boolean appliesTo(AnnotationTarget.Kind kind) {
        return kind == AnnotationTarget.Kind.CLASS;
    }

    public void transform(AnnotationsTransformer.TransformationContext context) {
        String className = context.getTarget().asClass().name().toString();
        if (this.classNames.contains(className)) {
            ((Transformation)context.transform().add(SecurityTransformerUtils.ROLES_ALLOWED, new AnnotationValue[]{AnnotationValue.createArrayValue((String)"value", (AnnotationValue[])this.rolesAllowed)})).done();
        }
    }
}

