/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.deployment;

import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.security.deployment.SecurityTransformerUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;

public class AdditionalDenyingUnannotatedTransformer
implements AnnotationsTransformer {
    private final Set<String> classNames;

    public AdditionalDenyingUnannotatedTransformer(Collection<String> classNames) {
        this.classNames = new HashSet<String>(classNames);
    }

    public boolean appliesTo(AnnotationTarget.Kind kind) {
        return kind == AnnotationTarget.Kind.CLASS;
    }

    public void transform(AnnotationsTransformer.TransformationContext context) {
        String className = context.getTarget().asClass().name().toString();
        if (this.classNames.contains(className)) {
            ((Transformation)context.transform().add(SecurityTransformerUtils.DENY_ALL, new AnnotationValue[0])).done();
        }
    }
}

