/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveClassBuildItem;
import io.quarkus.security.deployment.JCAProviderBuildItem;
import io.quarkus.security.deployment.SecurityConfig;
import io.quarkus.security.runtime.IdentityProviderManagerCreator;
import io.quarkus.security.runtime.SecurityIdentityAssociation;
import io.quarkus.security.runtime.SecurityIdentityProxy;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;

public class SecurityProcessor {
    private static final Logger log = Logger.getLogger(SecurityProcessor.class);
    SecurityConfig security;

    @BuildStep
    void services(BuildProducer<JCAProviderBuildItem> jcaProviders) {
        if (this.security.securityProviders != null) {
            for (String providerName : this.security.securityProviders) {
                jcaProviders.produce((BuildItem)new JCAProviderBuildItem(providerName));
                log.debugf("Added providerName: %s", (Object)providerName);
            }
        }
    }

    @BuildStep
    void registerJCAProviders(BuildProducer<ReflectiveClassBuildItem> classes, List<JCAProviderBuildItem> jcaProviders) {
        for (JCAProviderBuildItem provider : jcaProviders) {
            List<String> providerClasses = this.registerProvider(provider.getProviderName());
            for (String className : providerClasses) {
                classes.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{className}));
                log.debugf("Register JCA class: %s", (Object)className);
            }
        }
    }

    private List<String> registerProvider(String providerName) {
        ArrayList<String> providerClasses = new ArrayList<String>();
        Provider provider = Security.getProvider(providerName);
        providerClasses.add(provider.getClass().getName());
        Set<Provider.Service> services = provider.getServices();
        for (Provider.Service service : services) {
            String serviceClass = service.getClassName();
            providerClasses.add(serviceClass);
            String supportedKeyClasses = service.getAttribute("SupportedKeyClasses");
            if (supportedKeyClasses == null) continue;
            String[] keyClasses = supportedKeyClasses.split("\\|");
            providerClasses.addAll(Arrays.asList(keyClasses));
        }
        return providerClasses;
    }

    @BuildStep(providesCapabilities={"io.quarkus.security"})
    FeatureBuildItem feature() {
        return new FeatureBuildItem("security");
    }

    @BuildStep
    void registerAdditionalBeans(BuildProducer<AdditionalBeanBuildItem> beans) {
        beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(SecurityIdentityAssociation.class));
        beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(IdentityProviderManagerCreator.class));
        beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(SecurityIdentityProxy.class));
    }
}

