/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.runtime.security;

import io.quarkus.resteasy.reactive.server.runtime.security.EagerSecurityContext;
import io.quarkus.security.spi.runtime.MethodDescription;
import io.vertx.ext.web.RoutingContext;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.jboss.resteasy.reactive.common.model.ResourceClass;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.model.HandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.model.ServerResourceMethod;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class EagerSecurityInterceptorHandler
implements ServerRestHandler {
    private static final Consumer<RoutingContext> NULL_SENTINEL = new Consumer<RoutingContext>(){

        @Override
        public void accept(RoutingContext routingContext) {
        }
    };
    private volatile Consumer<RoutingContext> interceptor;

    private EagerSecurityInterceptorHandler() {
    }

    public void handle(ResteasyReactiveRequestContext requestContext) throws Exception {
        if (this.interceptor == NULL_SENTINEL) {
            return;
        }
        if (this.interceptor == null) {
            MethodDescription methodDescription = EagerSecurityContext.lazyMethodToMethodDescription(requestContext.getTarget().getLazyMethod());
            this.interceptor = EagerSecurityContext.instance.interceptorStorage.getInterceptor(methodDescription);
            if (this.interceptor == null) {
                this.interceptor = NULL_SENTINEL;
                return;
            }
        }
        this.interceptor.accept((RoutingContext)requestContext.unwrap(RoutingContext.class));
    }

    public static class Customizer
    implements HandlerChainCustomizer {
        public static HandlerChainCustomizer newInstance() {
            return new Customizer();
        }

        public List<ServerRestHandler> handlers(HandlerChainCustomizer.Phase phase, ResourceClass resourceClass, ServerResourceMethod serverResourceMethod) {
            if (phase == HandlerChainCustomizer.Phase.AFTER_MATCH) {
                return Collections.singletonList(new EagerSecurityInterceptorHandler());
            }
            return Collections.emptyList();
        }
    }
}

