/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.links.runtime.hal;

import io.quarkus.hal.HalLink;
import io.quarkus.hal.HalService;
import io.quarkus.resteasy.reactive.links.RestLinksProvider;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Link;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@RequestScoped
public class ResteasyReactiveHalService
extends HalService {
    private final RestLinksProvider linksProvider;

    @Inject
    public ResteasyReactiveHalService(RestLinksProvider linksProvider) {
        this.linksProvider = linksProvider;
    }

    protected Map<String, HalLink> getClassLinks(Class<?> entityType) {
        return this.linksToMap(this.linksProvider.getTypeLinks(entityType));
    }

    protected Map<String, HalLink> getInstanceLinks(Object entity) {
        return this.linksToMap(this.linksProvider.getInstanceLinks(entity));
    }

    private Map<String, HalLink> linksToMap(Collection<Link> refLinks) {
        HashMap<String, HalLink> links = new HashMap<String, HalLink>();
        for (Link link : refLinks) {
            links.put(link.getRel(), new HalLink(link.getUri().toString(), link.getTitle(), link.getType()));
        }
        return links;
    }
}

