/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.methods;

import io.quarkus.deployment.Capabilities;
import io.quarkus.gizmo.AnnotatedElement;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.rest.data.panache.deployment.ResourceMetadata;
import io.quarkus.rest.data.panache.deployment.methods.StandardMethodImplementor;
import io.quarkus.rest.data.panache.deployment.properties.ResourceProperties;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

public class OverrideUserMethodImplementor
extends StandardMethodImplementor {
    static final DotName REST_PATH = DotName.createSimple(Path.class);
    static final DotName REST_PRODUCES = DotName.createSimple(Produces.class);
    private final MethodInfo methodInfo;

    protected OverrideUserMethodImplementor(MethodInfo methodInfo, Capabilities capabilities) {
        super(capabilities);
        this.methodInfo = methodInfo;
    }

    @Override
    protected void implementInternal(ClassCreator classCreator, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, FieldDescriptor resourceField) {
        MethodCreator methodCreator = classCreator.getMethodCreator(MethodDescriptor.of((MethodInfo)this.methodInfo));
        methodCreator.setSignature(this.methodInfo.genericSignatureIfRequired());
        HashSet<String> produces = new HashSet<String>();
        for (AnnotationInstance annotation : this.methodInfo.annotations()) {
            if (annotation.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER) {
                short position = annotation.target().asMethodParameter().position();
                methodCreator.getParameterAnnotations((int)position).addAnnotation(annotation);
            }
            if (annotation.target().kind() != AnnotationTarget.Kind.METHOD) continue;
            if (REST_PRODUCES.equals((Object)annotation.name())) {
                AnnotationValue annotationValue = annotation.value();
                if (annotationValue == null) continue;
                produces.addAll(List.of(annotationValue.asStringArray()));
                continue;
            }
            methodCreator.addAnnotation(annotation);
        }
        ResultHandle[] params = new ResultHandle[this.methodInfo.parametersCount()];
        for (int paramIdx = 0; paramIdx < this.methodInfo.parametersCount(); ++paramIdx) {
            params[paramIdx] = methodCreator.getMethodParam(paramIdx);
        }
        if (this.methodInfo.hasAnnotation(REST_PATH)) {
            this.addLinksAnnotation((AnnotatedElement)methodCreator, resourceProperties, resourceMetadata.getEntityType(), this.getResourceMethodName());
            this.addSecurityAnnotations((AnnotatedElement)methodCreator, resourceProperties);
            this.addProducesAnnotation(produces, methodCreator, resourceProperties);
        }
        methodCreator.returnValue(methodCreator.invokeSpecialInterfaceMethod(this.methodInfo, methodCreator.getThis(), params));
        methodCreator.close();
    }

    @Override
    protected String getResourceMethodName() {
        return this.methodInfo.name();
    }

    @Override
    protected void addLinksAnnotation(AnnotatedElement element, ResourceProperties resourceProperties, String entityClassName, String rel) {
        if (!resourceProperties.isHal()) {
            return;
        }
        String linksAnnotationName = "io.quarkus.resteasy.reactive.links.RestLink";
        if (!this.methodInfo.hasAnnotation(linksAnnotationName)) {
            super.addLinksAnnotation(element, resourceProperties, entityClassName, rel);
        }
    }

    private void addProducesAnnotation(Set<String> definedProduces, MethodCreator methodCreator, ResourceProperties resourceProperties) {
        HashSet<String> produces = new HashSet<String>(definedProduces);
        produces.add("application/json");
        if (resourceProperties.isHal()) {
            produces.add("application/hal+json");
        }
        this.addProducesAnnotation((AnnotatedElement)methodCreator, produces.toArray(new String[0]));
    }
}

