/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.methods;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.deployment.Capabilities;
import io.quarkus.gizmo.AnnotatedElement;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.FunctionCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.rest.data.panache.deployment.ResourceMetadata;
import io.quarkus.rest.data.panache.deployment.methods.StandardMethodImplementor;
import io.quarkus.rest.data.panache.deployment.properties.ResourceProperties;
import io.quarkus.rest.data.panache.deployment.utils.SignatureMethodCreator;
import io.quarkus.rest.data.panache.deployment.utils.UniImplementor;
import io.quarkus.rest.data.panache.runtime.UpdateExecutor;
import io.smallrye.mutiny.Uni;
import jakarta.validation.Valid;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.lang.annotation.Annotation;
import java.util.function.Supplier;

public final class UpdateMethodImplementor
extends StandardMethodImplementor {
    private static final String METHOD_NAME = "update";
    private static final String RESOURCE_UPDATE_METHOD_NAME = "update";
    private static final String RESOURCE_GET_METHOD_NAME = "get";
    private static final String REL = "update";
    private static final String EXCEPTION_MESSAGE = "Failed to update an entity";

    public UpdateMethodImplementor(Capabilities capabilities) {
        super(capabilities);
    }

    @Override
    protected void implementInternal(ClassCreator classCreator, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, FieldDescriptor resourceField) {
        MethodCreator methodCreator = SignatureMethodCreator.getMethodCreator("update", classCreator, this.isNotReactivePanache() ? SignatureMethodCreator.responseType() : SignatureMethodCreator.uniType(resourceMetadata.getEntityType()), SignatureMethodCreator.param("id", resourceMetadata.getIdType()), SignatureMethodCreator.param("entity", resourceMetadata.getEntityType()), SignatureMethodCreator.param("uriInfo", UriInfo.class));
        this.addPathAnnotation((AnnotatedElement)methodCreator, this.appendToPath(resourceProperties.getPath("update"), "{id}"));
        this.addPutAnnotation((AnnotatedElement)methodCreator);
        this.addPathParamAnnotation(methodCreator.getParameterAnnotations(0), "id");
        this.addContextAnnotation(methodCreator.getParameterAnnotations(2));
        this.addConsumesAnnotation((AnnotatedElement)methodCreator, "application/json");
        this.addProducesJsonAnnotation((AnnotatedElement)methodCreator, resourceProperties);
        this.addLinksAnnotation((AnnotatedElement)methodCreator, resourceProperties, resourceMetadata.getEntityType(), "update");
        this.addMethodAnnotations((AnnotatedElement)methodCreator, resourceProperties.getMethodAnnotations("update"));
        this.addOpenApiResponseAnnotation((AnnotatedElement)methodCreator, Response.Status.CREATED, resourceMetadata.getEntityType());
        this.addSecurityAnnotations((AnnotatedElement)methodCreator, resourceProperties);
        if (this.hasValidatorCapability()) {
            methodCreator.getParameterAnnotations(1).addAnnotation(Valid.class);
        }
        ResultHandle resource = methodCreator.readInstanceField(resourceField, methodCreator.getThis());
        ResultHandle id = methodCreator.getMethodParam(0);
        ResultHandle entityToSave = methodCreator.getMethodParam(1);
        if (this.isNotReactivePanache()) {
            this.implementClassicVersion(methodCreator, resourceMetadata, resourceProperties, resource, id, entityToSave);
        } else {
            this.implementReactiveVersion(methodCreator, resourceMetadata, resourceProperties, resource, id, entityToSave);
        }
        methodCreator.close();
    }

    @Override
    protected String getResourceMethodName() {
        return "update";
    }

    private void implementReactiveVersion(MethodCreator methodCreator, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, ResultHandle resource, ResultHandle id, ResultHandle entityToSave) {
        ResultHandle uniResponse = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)resourceMetadata.getResourceClass(), (String)RESOURCE_GET_METHOD_NAME, Uni.class, (Object[])new Object[]{Object.class}), resource, new ResultHandle[]{id});
        methodCreator.returnValue(UniImplementor.flatMap((BytecodeCreator)methodCreator, uniResponse, EXCEPTION_MESSAGE, (getBody, itemWasFound) -> {
            ResultHandle uniUpdateEntity = getBody.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)resourceMetadata.getResourceClass(), (String)"update", Uni.class, (Object[])new Object[]{Object.class, Object.class}), resource, new ResultHandle[]{id, entityToSave});
            getBody.returnValue(UniImplementor.map(getBody, uniUpdateEntity, EXCEPTION_MESSAGE, (updateBody, itemUpdated) -> {
                BranchResult ifEntityIsNew = updateBody.ifNull(itemWasFound);
                ifEntityIsNew.trueBranch().returnValue(this.responseImplementor.created(ifEntityIsNew.trueBranch(), (ResultHandle)itemUpdated, resourceProperties));
                ifEntityIsNew.falseBranch().returnValue(this.responseImplementor.noContent(ifEntityIsNew.falseBranch()));
            }));
        }));
    }

    private void implementClassicVersion(MethodCreator methodCreator, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, ResultHandle resource, ResultHandle id, ResultHandle entityToSave) {
        TryBlock tryBlock = this.implementTryBlock((BytecodeCreator)methodCreator, EXCEPTION_MESSAGE);
        ResultHandle updateExecutor = this.getUpdateExecutor((BytecodeCreator)tryBlock);
        ResultHandle updateFunction = this.getUpdateFunction((BytecodeCreator)tryBlock, resourceMetadata.getResourceClass(), resource, id, entityToSave);
        ResultHandle newEntity = tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(UpdateExecutor.class, (String)"execute", Object.class, (Class[])new Class[]{Supplier.class}), updateExecutor, new ResultHandle[]{updateFunction});
        BranchResult createdNewEntity = tryBlock.ifNotNull(newEntity);
        createdNewEntity.trueBranch().returnValue(this.responseImplementor.created(createdNewEntity.trueBranch(), newEntity, resourceProperties));
        createdNewEntity.falseBranch().returnValue(this.responseImplementor.noContent(createdNewEntity.falseBranch()));
    }

    private ResultHandle getUpdateFunction(BytecodeCreator creator, String resourceClass, ResultHandle resource, ResultHandle id, ResultHandle entity) {
        FunctionCreator functionCreator = creator.createFunction(Supplier.class);
        BytecodeCreator functionBytecodeCreator = functionCreator.getBytecode();
        AssignableResultHandle entityToSave = functionBytecodeCreator.createVariable(Object.class);
        functionBytecodeCreator.assign(entityToSave, entity);
        BranchResult shouldUpdate = this.entityExists(functionBytecodeCreator, resourceClass, resource, id);
        this.updateAndReturn(shouldUpdate.trueBranch(), resourceClass, resource, id, (ResultHandle)entityToSave);
        this.createAndReturn(shouldUpdate.falseBranch(), resourceClass, resource, id, (ResultHandle)entityToSave);
        return functionCreator.getInstance();
    }

    private BranchResult entityExists(BytecodeCreator creator, String resourceClass, ResultHandle resource, ResultHandle id) {
        return creator.ifNotNull(creator.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)resourceClass, (String)RESOURCE_GET_METHOD_NAME, Object.class, (Object[])new Object[]{Object.class}), resource, new ResultHandle[]{id}));
    }

    private void createAndReturn(BytecodeCreator creator, String resourceClass, ResultHandle resource, ResultHandle id, ResultHandle entityToSave) {
        ResultHandle newEntity = creator.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)resourceClass, (String)"update", Object.class, (Object[])new Object[]{Object.class, Object.class}), resource, new ResultHandle[]{id, entityToSave});
        creator.returnValue(newEntity);
    }

    private void updateAndReturn(BytecodeCreator creator, String resourceClass, ResultHandle resource, ResultHandle id, ResultHandle entityToSave) {
        creator.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)resourceClass, (String)"update", Object.class, (Object[])new Object[]{Object.class, Object.class}), resource, new ResultHandle[]{id, entityToSave});
        creator.returnValue(creator.loadNull());
    }

    private ResultHandle getUpdateExecutor(BytecodeCreator creator) {
        ResultHandle arcContainer = creator.invokeStaticMethod(MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle instanceHandle = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{Class.class, Annotation[].class}), arcContainer, new ResultHandle[]{creator.loadClassFromTCCL(UpdateExecutor.class), creator.newArray(Annotation.class, 0)});
        ResultHandle instance = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)RESOURCE_GET_METHOD_NAME, Object.class, (Class[])new Class[0]), instanceHandle, new ResultHandle[0]);
        creator.ifNull(instance).trueBranch().throwException(RuntimeException.class, UpdateExecutor.class.getSimpleName() + " instance was not found");
        return instance;
    }
}

