/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.deployment;

import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.rest.client.reactive.deployment.DotNames;
import io.quarkus.rest.client.reactive.deployment.GeneratedClassResult;
import io.quarkus.rest.client.reactive.runtime.ResteasyReactiveResponseExceptionMapper;
import io.quarkus.runtime.util.HashUtil;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;

class ClientExceptionMapperHandler {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final ResultHandle[] EMPTY_RESULT_HANDLES_ARRAY = new ResultHandle[0];
    private static final MethodDescriptor GET_INVOKED_METHOD = MethodDescriptor.ofMethod(RestClientRequestContext.class, (String)"getInvokedMethod", Method.class, (Class[])new Class[0]);
    private static final MethodDescriptor GET_URI = MethodDescriptor.ofMethod(RestClientRequestContext.class, (String)"getUri", URI.class, (Class[])new Class[0]);
    private static final MethodDescriptor GET_PROPERTIES = MethodDescriptor.ofMethod(RestClientRequestContext.class, (String)"getProperties", Map.class, (Class[])new Class[0]);
    private static final MethodDescriptor GET_REQUEST_HEADERS_AS_MAP = MethodDescriptor.ofMethod(RestClientRequestContext.class, (String)"getRequestHeadersAsMap", MultivaluedMap.class, (Class[])new Class[0]);
    private final ClassOutput classOutput;

    ClientExceptionMapperHandler(ClassOutput classOutput) {
        this.classOutput = classOutput;
    }

    GeneratedClassResult generateResponseExceptionMapper(AnnotationInstance instance) {
        if (!DotNames.CLIENT_EXCEPTION_MAPPER.equals((Object)instance.name())) {
            throw new IllegalArgumentException("'clientExceptionMapperInstance' must be an instance of " + String.valueOf(DotNames.CLIENT_EXCEPTION_MAPPER));
        }
        MethodInfo targetMethod = null;
        boolean isValid = false;
        if (instance.target().kind() == AnnotationTarget.Kind.METHOD) {
            targetMethod = instance.target().asMethod();
            if (ClientExceptionMapperHandler.ignoreAnnotation(targetMethod)) {
                return null;
            }
            if ((targetMethod.flags() & 8) != 0) {
                String returnTypeClassName = targetMethod.returnType().name().toString();
                try {
                    boolean returnsRuntimeException = RuntimeException.class.isAssignableFrom(Class.forName(returnTypeClassName, false, Thread.currentThread().getContextClassLoader()));
                    if (returnsRuntimeException) {
                        isValid = true;
                    }
                }
                catch (ClassNotFoundException returnsRuntimeException) {
                    // empty catch block
                }
            }
        }
        if (!isValid) {
            String message = String.valueOf(DotNames.CLIENT_EXCEPTION_MAPPER) + " is only supported on static methods of REST Client interfaces that take 'jakarta.ws.rs.core.Response' as a single parameter and return 'java.lang.RuntimeException'.";
            if (targetMethod != null) {
                message = message + " Offending instance is '" + targetMethod.declaringClass().name().toString() + "#" + targetMethod.name() + "'";
            }
            throw new IllegalStateException(message);
        }
        int priority = 5000;
        AnnotationValue priorityAnnotationValue = instance.value("priority");
        if (priorityAnnotationValue != null) {
            priority = priorityAnnotationValue.asInt();
        }
        ClassInfo restClientInterfaceClassInfo = targetMethod.declaringClass();
        String generatedClassName = ClientExceptionMapperHandler.getGeneratedClassName(targetMethod);
        try (ClassCreator cc = ClassCreator.builder().classOutput(this.classOutput).className(generatedClassName).interfaces(new Class[]{ResteasyReactiveResponseExceptionMapper.class}).build();){
            MethodCreator toThrowable = cc.getMethodCreator("toThrowable", Throwable.class, new Class[]{Response.class, RestClientRequestContext.class});
            LinkedHashMap<String, ResultHandle> targetMethodParams = new LinkedHashMap<String, ResultHandle>();
            for (Type paramType : targetMethod.parameterTypes()) {
                ResultHandle targetMethodParamHandle;
                DotName paramTypeName = paramType.name();
                if (paramTypeName.equals((Object)ResteasyReactiveDotNames.RESPONSE)) {
                    targetMethodParamHandle = toThrowable.getMethodParam(0);
                } else if (paramTypeName.equals((Object)DotNames.METHOD)) {
                    targetMethodParamHandle = toThrowable.invokeVirtualMethod(GET_INVOKED_METHOD, toThrowable.getMethodParam(1), new ResultHandle[0]);
                } else if (paramTypeName.equals((Object)DotNames.URI)) {
                    targetMethodParamHandle = toThrowable.invokeVirtualMethod(GET_URI, toThrowable.getMethodParam(1), new ResultHandle[0]);
                } else if (this.isMapStringToObject(paramType)) {
                    targetMethodParamHandle = toThrowable.invokeVirtualMethod(GET_PROPERTIES, toThrowable.getMethodParam(1), new ResultHandle[0]);
                } else if (this.isMultivaluedMapStringToString(paramType)) {
                    targetMethodParamHandle = toThrowable.invokeVirtualMethod(GET_REQUEST_HEADERS_AS_MAP, toThrowable.getMethodParam(1), new ResultHandle[0]);
                } else {
                    String message = "Unsupported parameter type used in " + String.valueOf(DotNames.CLIENT_EXCEPTION_MAPPER) + ". See the Javadoc of the annotation for the supported types. Offending instance is '" + targetMethod.declaringClass().name().toString() + "#" + targetMethod.name() + "'";
                    throw new IllegalStateException(message);
                }
                targetMethodParams.put(paramTypeName.toString(), targetMethodParamHandle);
            }
            ResultHandle resultHandle = toThrowable.invokeStaticInterfaceMethod(MethodDescriptor.ofMethod((String)restClientInterfaceClassInfo.name().toString(), (String)targetMethod.name(), (String)targetMethod.returnType().name().toString(), (String[])targetMethodParams.keySet().toArray(EMPTY_STRING_ARRAY)), targetMethodParams.values().toArray(EMPTY_RESULT_HANDLES_ARRAY));
            toThrowable.returnValue(resultHandle);
            if (priority != 5000) {
                MethodCreator getPriority = cc.getMethodCreator("getPriority", Integer.TYPE, new Class[0]);
                getPriority.returnValue(getPriority.load(priority));
            }
        }
        return new GeneratedClassResult(restClientInterfaceClassInfo.name().toString(), generatedClassName, priority);
    }

    private boolean isMapStringToObject(Type paramType) {
        if (paramType.kind() != Type.Kind.PARAMETERIZED_TYPE) {
            return false;
        }
        ParameterizedType parameterizedType = paramType.asParameterizedType();
        if (!parameterizedType.name().equals((Object)DotNames.MAP)) {
            return false;
        }
        List arguments = parameterizedType.arguments();
        if (arguments.size() != 2) {
            return false;
        }
        return ((Type)arguments.get(0)).name().equals((Object)DotNames.STRING) && ((Type)arguments.get(1)).name().equals((Object)DotNames.OBJECT);
    }

    private boolean isMultivaluedMapStringToString(Type paramType) {
        if (paramType.kind() != Type.Kind.PARAMETERIZED_TYPE) {
            return false;
        }
        ParameterizedType parameterizedType = paramType.asParameterizedType();
        if (!parameterizedType.name().equals((Object)DotNames.MULTIVALUED_MAP)) {
            return false;
        }
        List arguments = parameterizedType.arguments();
        if (arguments.size() != 2) {
            return false;
        }
        return ((Type)arguments.get(0)).name().equals((Object)DotNames.STRING) && ((Type)arguments.get(1)).name().equals((Object)DotNames.STRING);
    }

    public static String getGeneratedClassName(MethodInfo methodInfo) {
        StringBuilder sigBuilder = new StringBuilder();
        sigBuilder.append(methodInfo.name()).append("_").append(methodInfo.returnType().name().toString());
        for (Type i : methodInfo.parameterTypes()) {
            sigBuilder.append(i.name().toString());
        }
        return methodInfo.declaringClass().name().toString() + "_" + methodInfo.name() + "_ResponseExceptionMapper_" + HashUtil.sha1((String)sigBuilder.toString());
    }

    private static boolean ignoreAnnotation(MethodInfo methodInfo) {
        return methodInfo.declaringClass().name().toString().contains("$Companion");
    }
}

