/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.datasource.timeseries.AddArgs;
import io.quarkus.redis.datasource.timeseries.Aggregation;
import io.quarkus.redis.datasource.timeseries.AlterArgs;
import io.quarkus.redis.datasource.timeseries.CreateArgs;
import io.quarkus.redis.datasource.timeseries.Filter;
import io.quarkus.redis.datasource.timeseries.IncrementArgs;
import io.quarkus.redis.datasource.timeseries.MGetArgs;
import io.quarkus.redis.datasource.timeseries.MRangeArgs;
import io.quarkus.redis.datasource.timeseries.RangeArgs;
import io.quarkus.redis.datasource.timeseries.SeriesSample;
import io.quarkus.redis.datasource.timeseries.TimeSeriesRange;
import io.quarkus.redis.runtime.datasource.AbstractRedisCommands;
import io.quarkus.redis.runtime.datasource.Marshaller;
import io.quarkus.redis.runtime.datasource.RedisCommand;
import io.quarkus.redis.runtime.datasource.RedisCommandExecutor;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.vertx.mutiny.redis.client.Command;
import io.vertx.mutiny.redis.client.Response;
import java.lang.reflect.Type;
import java.time.Duration;

public class AbstractTimeSeriesCommands<K>
extends AbstractRedisCommands {
    AbstractTimeSeriesCommands(RedisCommandExecutor redis, Type k) {
        super(redis, new Marshaller(k));
    }

    Uni<Response> _tsCreate(K key, CreateArgs args) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)args, (String)"args");
        RedisCommand cmd = RedisCommand.of(Command.TS_CREATE).put(this.marshaller.encode(key)).putArgs(args);
        return this.execute(cmd);
    }

    Uni<Response> _tsCreate(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        RedisCommand cmd = RedisCommand.of(Command.TS_CREATE).put(this.marshaller.encode(key));
        return this.execute(cmd);
    }

    Uni<Response> _tsAdd(K key, long timestamp, double value, AddArgs args) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.positive((long)timestamp, (String)"timestamp");
        ParameterValidation.nonNull((Object)args, (String)"args");
        RedisCommand cmd = RedisCommand.of(Command.TS_ADD).put(this.marshaller.encode(key)).put(timestamp).put(value).putArgs(args);
        return this.execute(cmd);
    }

    Uni<Response> _tsAdd(K key, long timestamp, double value) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.positive((long)timestamp, (String)"timestamp");
        RedisCommand cmd = RedisCommand.of(Command.TS_ADD).put(this.marshaller.encode(key)).put(timestamp).put(value);
        return this.execute(cmd);
    }

    Uni<Response> _tsAdd(K key, double value) {
        ParameterValidation.nonNull(key, (String)"key");
        RedisCommand cmd = RedisCommand.of(Command.TS_ADD).put(this.marshaller.encode(key)).put("*").put(value);
        return this.execute(cmd);
    }

    Uni<Response> _tsAdd(K key, double value, AddArgs args) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)args, (String)"args");
        RedisCommand cmd = RedisCommand.of(Command.TS_ADD).put(this.marshaller.encode(key)).put("*").put(value).putArgs(args);
        return this.execute(cmd);
    }

    Uni<Response> _tsAlter(K key, AlterArgs args) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)args, (String)"args");
        RedisCommand cmd = RedisCommand.of(Command.TS_ALTER).put(this.marshaller.encode(key)).putArgs(args);
        return this.execute(cmd);
    }

    Uni<Response> _tsCreateRule(K key, K destKey, Aggregation aggregation, Duration bucketDuration) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(destKey, (String)"destKey");
        ParameterValidation.nonNull((Object)((Object)aggregation), (String)"aggregation");
        ParameterValidation.nonNull((Object)bucketDuration, (String)"bucketDuration");
        RedisCommand cmd = RedisCommand.of(Command.TS_CREATERULE).put(this.marshaller.encode(key)).put(this.marshaller.encode(destKey)).put("AGGREGATION").put(aggregation.toString()).put(bucketDuration.toMillis());
        return this.execute(cmd);
    }

    Uni<Response> _tsCreateRule(K key, K destKey, Aggregation aggregation, Duration bucketDuration, long alignTimestamp) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(destKey, (String)"destKey");
        ParameterValidation.nonNull((Object)((Object)aggregation), (String)"aggregation");
        ParameterValidation.nonNull((Object)bucketDuration, (String)"bucketDuration");
        ParameterValidation.positive((long)alignTimestamp, (String)"alignTimestamp");
        RedisCommand cmd = RedisCommand.of(Command.TS_CREATERULE).put(this.marshaller.encode(key)).put(this.marshaller.encode(destKey)).put("AGGREGATION").put(aggregation.toString()).put(bucketDuration.toMillis()).put(alignTimestamp);
        return this.execute(cmd);
    }

    Uni<Response> _tsDecrBy(K key, double value) {
        ParameterValidation.nonNull(key, (String)"key");
        RedisCommand cmd = RedisCommand.of(Command.TS_DECRBY).put(this.marshaller.encode(key)).put(value);
        return this.execute(cmd);
    }

    Uni<Response> _tsDecrBy(K key, double value, IncrementArgs args) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)args, (String)"args");
        RedisCommand cmd = RedisCommand.of(Command.TS_DECRBY).put(this.marshaller.encode(key)).put(value).putArgs(args);
        return this.execute(cmd);
    }

    Uni<Response> _tsDel(K key, long fromTimestamp, long toTimestamp) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.positive((long)fromTimestamp, (String)"fromTimestamp");
        ParameterValidation.positive((long)toTimestamp, (String)"toTimestamp");
        RedisCommand cmd = RedisCommand.of(Command.TS_DEL).put(this.marshaller.encode(key)).put(fromTimestamp).put(toTimestamp);
        return this.execute(cmd);
    }

    Uni<Response> _tsDeleteRule(K key, K destKey) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull(destKey, (String)"destKey");
        RedisCommand cmd = RedisCommand.of(Command.TS_DELETERULE).put(this.marshaller.encode(key)).put(this.marshaller.encode(destKey));
        return this.execute(cmd);
    }

    Uni<Response> _tsGet(K key) {
        ParameterValidation.nonNull(key, (String)"key");
        RedisCommand cmd = RedisCommand.of(Command.TS_GET).put(this.marshaller.encode(key));
        return this.execute(cmd);
    }

    Uni<Response> _tsGet(K key, boolean latest) {
        ParameterValidation.nonNull(key, (String)"key");
        RedisCommand cmd = RedisCommand.of(Command.TS_GET).put(this.marshaller.encode(key));
        if (latest) {
            cmd.put("LATEST");
        }
        return this.execute(cmd);
    }

    Uni<Response> _tsIncrBy(K key, double value) {
        ParameterValidation.nonNull(key, (String)"key");
        RedisCommand cmd = RedisCommand.of(Command.TS_INCRBY).put(this.marshaller.encode(key)).put(value);
        return this.execute(cmd);
    }

    Uni<Response> _tsIncrBy(K key, double value, IncrementArgs args) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)args, (String)"args");
        RedisCommand cmd = RedisCommand.of(Command.TS_INCRBY).put(this.marshaller.encode(key)).put(value).putArgs(args);
        return this.execute(cmd);
    }

    Uni<Response> _tsMAdd(SeriesSample<K> ... samples) {
        ParameterValidation.doesNotContainNull((Object[])samples, (String)"samples");
        if (samples.length == 0) {
            return Uni.createFrom().failure((Throwable)new IllegalArgumentException("`samples` must not be empty"));
        }
        RedisCommand cmd = RedisCommand.of(Command.TS_MADD);
        for (SeriesSample<K> sample : samples) {
            cmd.put(this.marshaller.encode(sample.key));
            if (sample.timestamp == Long.MAX_VALUE) {
                cmd.put("*");
            } else {
                cmd.put(sample.timestamp);
            }
            cmd.put(sample.value);
        }
        return this.execute(cmd);
    }

    Uni<Response> _tsMGet(MGetArgs args, Filter ... filters) {
        ParameterValidation.nonNull((Object)args, (String)"args");
        ParameterValidation.doesNotContainNull((Object[])filters, (String)"filters");
        if (filters.length == 0) {
            return Uni.createFrom().failure((Throwable)new IllegalArgumentException("`filters` must not be empty"));
        }
        RedisCommand cmd = RedisCommand.of(Command.TS_MGET).putArgs(args);
        cmd.put("FILTER");
        for (Filter filter : filters) {
            cmd.put(filter.toString());
        }
        return this.execute(cmd);
    }

    Uni<Response> _tsMGet(Filter ... filters) {
        ParameterValidation.doesNotContainNull((Object[])filters, (String)"filters");
        if (filters.length == 0) {
            return Uni.createFrom().failure((Throwable)new IllegalArgumentException("`filters` must not be empty"));
        }
        RedisCommand cmd = RedisCommand.of(Command.TS_MGET);
        cmd.put("FILTER");
        for (Filter filter : filters) {
            cmd.put(filter.toString());
        }
        return this.execute(cmd);
    }

    Uni<Response> _tsMRange(TimeSeriesRange range, Filter ... filters) {
        ParameterValidation.nonNull((Object)range, (String)"range");
        ParameterValidation.doesNotContainNull((Object[])filters, (String)"filters");
        if (filters.length == 0) {
            return Uni.createFrom().failure((Throwable)new IllegalArgumentException("`filters` must not be empty"));
        }
        RedisCommand cmd = RedisCommand.of(Command.TS_MRANGE).putAll(range.toArgs());
        cmd.put("FILTER");
        for (Filter filter : filters) {
            cmd.put(filter.toString());
        }
        return this.execute(cmd);
    }

    Uni<Response> _tsMRange(TimeSeriesRange range, MRangeArgs args, Filter ... filters) {
        ParameterValidation.nonNull((Object)range, (String)"range");
        ParameterValidation.nonNull((Object)args, (String)"args");
        ParameterValidation.doesNotContainNull((Object[])filters, (String)"filters");
        if (filters.length == 0) {
            return Uni.createFrom().failure((Throwable)new IllegalArgumentException("`filters` must not be empty"));
        }
        RedisCommand cmd = RedisCommand.of(Command.TS_MRANGE).putAll(range.toArgs()).putArgs(args);
        cmd.put("FILTER");
        for (Filter filter : filters) {
            cmd.put(filter.toString());
        }
        cmd.putAll(args.getGroupByClauseArgs());
        return this.execute(cmd);
    }

    Uni<Response> _tsMRevRange(TimeSeriesRange range, Filter ... filters) {
        ParameterValidation.nonNull((Object)range, (String)"range");
        ParameterValidation.doesNotContainNull((Object[])filters, (String)"filters");
        RedisCommand cmd = RedisCommand.of(Command.TS_MREVRANGE).putAll(range.toArgs());
        cmd.put("FILTER");
        for (Filter filter : filters) {
            cmd.put(filter.toString());
        }
        return this.execute(cmd);
    }

    Uni<Response> _tsMRevRange(TimeSeriesRange range, MRangeArgs args, Filter ... filters) {
        ParameterValidation.nonNull((Object)args, (String)"args");
        ParameterValidation.nonNull((Object)range, (String)"range");
        ParameterValidation.doesNotContainNull((Object[])filters, (String)"filters");
        if (filters.length == 0) {
            return Uni.createFrom().failure((Throwable)new IllegalArgumentException("`filters` must not be empty"));
        }
        RedisCommand cmd = RedisCommand.of(Command.TS_MREVRANGE).putAll(range.toArgs()).putArgs(args);
        cmd.put("FILTER");
        for (Filter filter : filters) {
            cmd.put(filter.toString());
        }
        return this.execute(cmd);
    }

    Uni<Response> _tsQueryIndex(Filter ... filters) {
        ParameterValidation.doesNotContainNull((Object[])filters, (String)"filters");
        if (filters.length == 0) {
            return Uni.createFrom().failure((Throwable)new IllegalArgumentException("`filters` must not be empty"));
        }
        RedisCommand cmd = RedisCommand.of(Command.TS_QUERYINDEX);
        for (Filter filter : filters) {
            cmd.put(filter.toString());
        }
        return this.execute(cmd);
    }

    Uni<Response> _tsRange(K key, TimeSeriesRange range) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)range, (String)"range");
        RedisCommand cmd = RedisCommand.of(Command.TS_RANGE).put(this.marshaller.encode(key)).putAll(range.toArgs());
        return this.execute(cmd);
    }

    Uni<Response> _tsRange(K key, TimeSeriesRange range, RangeArgs args) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)range, (String)"range");
        ParameterValidation.nonNull((Object)args, (String)"args");
        RedisCommand cmd = RedisCommand.of(Command.TS_RANGE).put(this.marshaller.encode(key)).putAll(range.toArgs()).putArgs(args);
        return this.execute(cmd);
    }

    Uni<Response> _tsRevRange(K key, TimeSeriesRange range) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)range, (String)"range");
        RedisCommand cmd = RedisCommand.of(Command.TS_REVRANGE).put(this.marshaller.encode(key)).putAll(range.toArgs());
        return this.execute(cmd);
    }

    Uni<Response> _tsRevRange(K key, TimeSeriesRange range, RangeArgs args) {
        ParameterValidation.nonNull(key, (String)"key");
        ParameterValidation.nonNull((Object)range, (String)"range");
        ParameterValidation.nonNull((Object)args, (String)"args");
        RedisCommand cmd = RedisCommand.of(Command.TS_REVRANGE).put(this.marshaller.encode(key)).putAll(range.toArgs()).putArgs(args);
        return this.execute(cmd);
    }
}

