/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.client;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.redis.client.RedisHostsProvider;
import io.quarkus.redis.client.RedisOptionsCustomizer;
import io.quarkus.redis.runtime.client.config.NetConfig;
import io.quarkus.redis.runtime.client.config.RedisClientConfig;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.tls.TlsConfiguration;
import io.quarkus.tls.TlsConfigurationRegistry;
import io.quarkus.tls.runtime.config.TlsConfigUtils;
import io.quarkus.vertx.core.runtime.SSLConfigHelper;
import io.quarkus.vertx.core.runtime.config.JksConfiguration;
import io.quarkus.vertx.core.runtime.config.PemKeyCertConfiguration;
import io.quarkus.vertx.core.runtime.config.PemTrustCertConfiguration;
import io.quarkus.vertx.core.runtime.config.PfxConfiguration;
import io.smallrye.common.annotation.Identifier;
import io.vertx.core.Vertx;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisClientType;
import io.vertx.redis.client.RedisOptions;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

public class VertxRedisClientFactory {
    public static final String DEFAULT_CLIENT = "<default>";
    public static String NON_RESERVED_URI_PATTERN = "[^a-zA-Z0-9\\-_.~]";
    private static final Logger LOGGER = Logger.getLogger(VertxRedisClientFactory.class);

    private VertxRedisClientFactory() {
    }

    public static Redis create(final String name, Vertx vertx, final RedisClientConfig config, TlsConfigurationRegistry tlsRegistry) {
        final RedisOptions options = new RedisOptions();
        Consumer<Set<URI>> configureOptions = new Consumer<Set<URI>>(){

            @Override
            public void accept(Set<URI> uris) {
                for (URI uri : uris) {
                    if (config.configureClientName().booleanValue()) {
                        String client = config.clientName().orElse(name);
                        String newURI = VertxRedisClientFactory.applyClientQueryParam(client, uri);
                        options.addConnectionString(newURI);
                        continue;
                    }
                    options.addConnectionString(uri.toString().trim());
                }
            }
        };
        ArrayList<URI> hosts = new ArrayList<URI>();
        if (config.hosts().isPresent()) {
            hosts.addAll((Collection)config.hosts().get());
            configureOptions.accept(config.hosts().get());
        } else if (config.hostsProviderName().isPresent()) {
            RedisHostsProvider hostsProvider = VertxRedisClientFactory.findProvider(config.hostsProviderName().get());
            Set<URI> computedHosts = hostsProvider.getHosts();
            hosts.addAll(computedHosts);
            configureOptions.accept(computedHosts);
        } else {
            throw new ConfigurationException("Redis host not configured - you must either configure 'quarkus.redis.hosts` or 'quarkus.redis.host-provider-name' and have a bean providing the hosts programmatically.");
        }
        if (RedisClientType.STANDALONE == config.clientType() && hosts.size() > 1) {
            throw new ConfigurationException("Multiple Redis hosts supplied for non-clustered configuration");
        }
        config.masterName().ifPresent(arg_0 -> ((RedisOptions)options).setMasterName(arg_0));
        options.setMaxNestedArrays(config.maxNestedArrays());
        options.setMaxPoolSize(config.maxPoolSize());
        options.setMaxPoolWaiting(config.maxPoolWaiting());
        options.setMaxWaitingHandlers(config.maxWaitingHandlers());
        options.setProtocolNegotiation(config.protocolNegotiation());
        config.preferredProtocolVersion().ifPresent(arg_0 -> ((RedisOptions)options).setPreferredProtocolVersion(arg_0));
        options.setPassword((String)config.password().orElse(null));
        config.poolCleanerInterval().ifPresent(d -> options.setPoolCleanerInterval((int)d.toMillis()));
        config.poolRecycleTimeout().ifPresent(d -> options.setPoolRecycleTimeout((int)d.toMillis()));
        long topologyCacheTtl = config.topologyCacheTtl().orElse(config.hashSlotCacheTtl()).toMillis();
        options.setHashSlotCacheTTL(topologyCacheTtl);
        options.setTopologyCacheTTL(topologyCacheTtl);
        config.role().ifPresent(arg_0 -> ((RedisOptions)options).setRole(arg_0));
        options.setType(config.clientType());
        config.replicas().ifPresent(arg_0 -> ((RedisOptions)options).setUseReplicas(arg_0));
        options.setAutoFailover(config.autoFailover());
        config.topology().ifPresent(arg_0 -> ((RedisOptions)options).setTopology(arg_0));
        config.clusterTransactions().ifPresent(arg_0 -> ((RedisOptions)options).setClusterTransactions(arg_0));
        options.setNetClientOptions(VertxRedisClientFactory.toNetClientOptions(config));
        VertxRedisClientFactory.configureTLS(name, config, tlsRegistry, options.getNetClientOptions(), hosts);
        options.setPoolName(name);
        options.getNetClientOptions().setMetricsName("redis|" + name);
        VertxRedisClientFactory.customize(name, options);
        return Redis.createClient((Vertx)vertx, (RedisOptions)options);
    }

    public static String applyClientQueryParam(String client, URI uri) {
        Object query;
        boolean hasClient;
        if (client.matches(".*" + NON_RESERVED_URI_PATTERN + ".*")) {
            LOGGER.warn((Object)"The client query parameter contains reserved URI characters. This may result in an incorrect client name after URI encoding.");
        }
        if (hasClient = VertxRedisClientFactory.hasRedisClientParameter((String)(query = uri.getQuery()))) {
            LOGGER.warnf("Your host already has a client name. The client name %s will be disregarded.", (Object)client);
            return uri.toString().trim();
        }
        query = query == null ? "client=" + client : uri.getQuery() + "&client=" + client;
        try {
            return new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), (String)query, uri.getFragment()).toString().trim();
        }
        catch (URISyntaxException e) {
            LOGGER.warnf("Was not possible to generate a new Redis URL with client query parameter, the value is: %s", (Object)client);
            return uri.toString().trim();
        }
    }

    private static boolean hasRedisClientParameter(String query) {
        if (query != null) {
            String[] pairs;
            for (String pair : pairs = query.split("&")) {
                String[] keyValue = pair.split("=");
                if (keyValue.length != 2 || !keyValue[0].equals("client")) continue;
                return true;
            }
        }
        return false;
    }

    private static void customize(String name, RedisOptions options) {
        if (Arc.container() != null) {
            List customizers = Arc.container().listAll(RedisOptionsCustomizer.class, new Annotation[0]);
            for (InstanceHandle customizer : customizers) {
                ((RedisOptionsCustomizer)customizer.get()).customize(name, options);
            }
        }
    }

    private static NetClientOptions toNetClientOptions(RedisClientConfig config) {
        NetConfig tcp = config.tcp();
        NetClientOptions net = new NetClientOptions();
        tcp.applicationLayerProtocols().ifPresent(arg_0 -> ((NetClientOptions)net).setApplicationLayerProtocols(arg_0));
        tcp.connectionTimeout().ifPresent(d -> net.setConnectTimeout((int)d.toMillis()));
        tcp.idleTimeout().ifPresent(d -> net.setIdleTimeout((int)d.toSeconds()));
        tcp.keepAlive().ifPresent(b -> net.setTcpKeepAlive(true));
        tcp.noDelay().ifPresent(b -> net.setTcpNoDelay(true));
        net.setReconnectAttempts(config.reconnectAttempts());
        net.setReconnectInterval(config.reconnectInterval().toMillis());
        tcp.localAddress().ifPresent(arg_0 -> ((NetClientOptions)net).setLocalAddress(arg_0));
        tcp.nonProxyHosts().ifPresent(arg_0 -> ((NetClientOptions)net).setNonProxyHosts(arg_0));
        if (tcp.proxyOptions().host().isPresent()) {
            ProxyOptions po = new ProxyOptions();
            po.setHost(tcp.proxyOptions().host().get());
            po.setType(tcp.proxyOptions().type());
            po.setPort(tcp.proxyOptions().port());
            tcp.proxyOptions().username().ifPresent(arg_0 -> ((ProxyOptions)po).setUsername(arg_0));
            tcp.proxyOptions().password().ifPresent(arg_0 -> ((ProxyOptions)po).setPassword(arg_0));
            net.setProxyOptions(po);
        }
        tcp.readIdleTimeout().ifPresent(d -> net.setReadIdleTimeout((int)d.toSeconds()));
        tcp.reconnectAttempts().ifPresent(arg_0 -> ((NetClientOptions)net).setReconnectAttempts(arg_0));
        tcp.reconnectInterval().ifPresent(v -> net.setReconnectInterval(v.toMillis()));
        tcp.reuseAddress().ifPresent(arg_0 -> ((NetClientOptions)net).setReuseAddress(arg_0));
        tcp.reusePort().ifPresent(arg_0 -> ((NetClientOptions)net).setReusePort(arg_0));
        tcp.receiveBufferSize().ifPresent(arg_0 -> ((NetClientOptions)net).setReceiveBufferSize(arg_0));
        tcp.sendBufferSize().ifPresent(arg_0 -> ((NetClientOptions)net).setSendBufferSize(arg_0));
        tcp.soLinger().ifPresent(d -> net.setSoLinger((int)d.toMillis()));
        tcp.secureTransportProtocols().ifPresent(arg_0 -> ((NetClientOptions)net).setEnabledSecureTransportProtocols(arg_0));
        tcp.trafficClass().ifPresent(arg_0 -> ((NetClientOptions)net).setTrafficClass(arg_0));
        tcp.noDelay().ifPresent(arg_0 -> ((NetClientOptions)net).setTcpNoDelay(arg_0));
        tcp.cork().ifPresent(arg_0 -> ((NetClientOptions)net).setTcpCork(arg_0));
        tcp.keepAlive().ifPresent(arg_0 -> ((NetClientOptions)net).setTcpKeepAlive(arg_0));
        tcp.fastOpen().ifPresent(arg_0 -> ((NetClientOptions)net).setTcpFastOpen(arg_0));
        tcp.quickAck().ifPresent(arg_0 -> ((NetClientOptions)net).setTcpQuickAck(arg_0));
        tcp.writeIdleTimeout().ifPresent(d -> net.setWriteIdleTimeout((int)d.toSeconds()));
        return net;
    }

    public static RedisHostsProvider findProvider(String name) {
        InjectableInstance providers;
        ArcContainer container = Arc.container();
        if (name != null) {
            providers = container.select(RedisHostsProvider.class, new Annotation[]{Identifier.Literal.of((String)name)});
            if (providers.isUnsatisfied()) {
                throw new ConfigurationException("Unable to find redis host provider identified with " + name);
            }
        } else {
            providers = container.select(RedisHostsProvider.class, new Annotation[0]);
            if (providers.isUnsatisfied()) {
                throw new ConfigurationException("Unable to find redis host provider");
            }
        }
        return (RedisHostsProvider)providers.get();
    }

    private static void configureTLS(String name, RedisClientConfig config, TlsConfigurationRegistry tlsRegistry, NetClientOptions net, List<URI> hosts) {
        TlsConfiguration configuration = null;
        boolean defaultTrustAll = false;
        boolean tlsFromHosts = false;
        for (URI uri : hosts) {
            if (!"rediss".equals(uri.getScheme())) continue;
            tlsFromHosts = true;
            break;
        }
        if (config.tlsConfigurationName().isPresent()) {
            Optional maybeConfiguration = tlsRegistry.get(config.tlsConfigurationName().get());
            if (maybeConfiguration.isEmpty()) {
                throw new IllegalStateException("Unable to find the TLS configuration " + config.tlsConfigurationName().get() + " for the Redis client " + name + ".");
            }
            configuration = (TlsConfiguration)maybeConfiguration.get();
        } else if (tlsRegistry.getDefault().isPresent() && ((TlsConfiguration)tlsRegistry.getDefault().get()).isTrustAll() && (defaultTrustAll = ((TlsConfiguration)tlsRegistry.getDefault().get()).isTrustAll())) {
            LOGGER.warn((Object)("The default TLS configuration is set to trust all certificates. This is a security risk.Please use a named TLS configuration for the Redis client " + name + " to avoid this warning."));
        }
        if (configuration != null && !tlsFromHosts) {
            LOGGER.warnf("The Redis client %s is configured with a named TLS configuration but the hosts are not using the `rediss://` scheme - Disabling TLS", (Object)name);
        }
        if (configuration != null) {
            TlsConfigUtils.configure((NetClientOptions)net, configuration);
            net.setSsl(tlsFromHosts);
        } else {
            config.tcp().alpn().ifPresent(arg_0 -> ((NetClientOptions)net).setUseAlpn(arg_0));
            String verificationAlgorithm = config.tls().hostnameVerificationAlgorithm();
            if ("NONE".equalsIgnoreCase(verificationAlgorithm)) {
                net.setHostnameVerificationAlgorithm("");
            } else {
                net.setHostnameVerificationAlgorithm(verificationAlgorithm);
            }
            net.setSsl(config.tls().enabled() || tlsFromHosts);
            net.setTrustAll(config.tls().trustAll() || defaultTrustAll);
            SSLConfigHelper.configurePemTrustOptions((TCPSSLOptions)net, (PemTrustCertConfiguration)config.tls().trustCertificatePem());
            SSLConfigHelper.configureJksTrustOptions((TCPSSLOptions)net, (JksConfiguration)config.tls().trustCertificateJks());
            SSLConfigHelper.configurePfxTrustOptions((TCPSSLOptions)net, (PfxConfiguration)config.tls().trustCertificatePfx());
            SSLConfigHelper.configurePemKeyCertOptions((TCPSSLOptions)net, (PemKeyCertConfiguration)config.tls().keyCertificatePem());
            SSLConfigHelper.configureJksKeyCertOptions((TCPSSLOptions)net, (JksConfiguration)config.tls().keyCertificateJks());
            SSLConfigHelper.configurePfxKeyCertOptions((TCPSSLOptions)net, (PfxConfiguration)config.tls().keyCertificatePfx());
        }
    }
}

