/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource;

import java.util.ArrayList;
import java.util.List;

public class ScanArgs {
    private long count = -1L;
    private String match;

    public ScanArgs count(long count) {
        if (count <= 0L) {
            throw new IllegalArgumentException("`count` must be strictly positive");
        }
        this.count = count;
        return this;
    }

    public ScanArgs match(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("`pattern` must not be `null`");
        }
        this.match = pattern;
        return this;
    }

    public List<String> toArgs() {
        ArrayList<String> args = new ArrayList<String>();
        if (this.count != -1L) {
            args.add("COUNT");
            args.add(Long.toString(this.count));
        }
        if (this.match != null) {
            args.add("MATCH");
            args.add(this.match);
        }
        return args;
    }
}

