/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.runtime.datasource;

import io.quarkus.redis.runtime.datasource.Marshaller;
import io.quarkus.redis.runtime.datasource.RedisCommand;
import io.quarkus.redis.runtime.datasource.RedisCommandExecutor;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.redis.client.Response;
import io.vertx.redis.client.ResponseType;
import java.util.Set;

public class AbstractRedisCommands {
    protected final RedisCommandExecutor redis;
    protected final Marshaller marshaller;

    public AbstractRedisCommands(RedisCommandExecutor redis, Marshaller marshaller) {
        this.redis = redis;
        this.marshaller = marshaller;
    }

    public Uni<Response> execute(RedisCommand cmd) {
        return this.redis.execute(cmd.toRequest());
    }

    static boolean isMap(Response response) {
        try {
            return response != null && response.type() == ResponseType.MULTI && AbstractRedisCommands.notEmptyOrNull(response.getKeys());
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private static boolean notEmptyOrNull(Set<String> keys) {
        return keys != null && !keys.isEmpty();
    }
}

