/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.search;

import io.quarkus.redis.runtime.datasource.Validation;
import io.smallrye.mutiny.helpers.ParameterValidation;

public class NumericFilter {
    private final String field;
    private final Number min;
    private final Number max;
    private final boolean inclusiveMin;
    private final boolean inclusiveMax;

    public static NumericFilter from(String field, int min, int max) {
        return new NumericFilter(field, min, max);
    }

    public static NumericFilter from(String field, long min, long max) {
        return new NumericFilter(field, min, max);
    }

    public static NumericFilter from(String field, double min, double max) {
        return new NumericFilter(field, min, max);
    }

    public NumericFilter(String field, Number min, Number max) {
        this(field, min, true, max, true);
    }

    public NumericFilter(String field, Number min, boolean inclusiveMin, Number max, boolean inclusiveMax) {
        this.field = Validation.notNullOrBlank(field, "field");
        this.min = (Number)ParameterValidation.nonNull((Object)min, (String)"min");
        this.max = (Number)ParameterValidation.nonNull((Object)max, (String)"max");
        this.inclusiveMin = inclusiveMin;
        this.inclusiveMax = inclusiveMax;
    }

    public static NumericFilter unbounded(String field) {
        return new NumericFilter(field, null, null);
    }

    public boolean isUnbounded() {
        if (this.min == null && this.max == null) {
            return true;
        }
        return this.min != null && Double.isInfinite(this.min.doubleValue()) && this.max != null && Double.isInfinite(this.max.doubleValue());
    }

    public String getLowerBound() {
        if (this.isUnbounded() || this.min == null || Double.isInfinite(this.min.doubleValue())) {
            return "-inf";
        }
        if (!this.inclusiveMin) {
            return "(" + String.valueOf(this.min);
        }
        return this.min.toString();
    }

    public String getUpperBound() {
        if (this.isUnbounded() || this.max == null || Double.isInfinite(this.max.doubleValue())) {
            return "+inf";
        }
        if (!this.inclusiveMax) {
            return "(" + String.valueOf(this.max);
        }
        return this.max.toString();
    }

    public String getField() {
        return this.field;
    }
}

