/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource;

import io.quarkus.redis.datasource.RedisCommandExtraArguments;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SortArgs
implements RedisCommandExtraArguments {
    private String direction;
    private String by;
    private Limit limit = Limit.noLimit();
    private boolean alpha;
    private List<String> get;

    public SortArgs ascending() {
        this.direction = "ASC";
        return this;
    }

    public SortArgs descending() {
        this.direction = "DESC";
        return this;
    }

    public SortArgs limit(Limit limit) {
        this.limit = limit;
        return this;
    }

    public SortArgs limit(long offset, long count) {
        this.limit = new Limit(offset, count);
        return this;
    }

    public SortArgs limit(long count) {
        this.limit = new Limit(count);
        return this;
    }

    public SortArgs alpha() {
        this.alpha = true;
        return this;
    }

    public SortArgs by(String by) {
        this.by = by;
        return this;
    }

    public SortArgs get(List<String> get) {
        this.get = get;
        return this;
    }

    public SortArgs get(String get) {
        if (this.get == null) {
            this.get = new ArrayList<String>();
        }
        this.get.add(get);
        return this;
    }

    @Override
    public List<Object> toArgs() {
        ArrayList<Object> args = new ArrayList<Object>();
        if (this.by != null && !this.by.isBlank()) {
            args.add("BY");
            args.add(this.by);
        }
        if (this.limit != null) {
            args.addAll(this.limit.toArgs());
        }
        if (this.get != null && !this.get.isEmpty()) {
            for (String s : this.get) {
                if (s == null || s.isBlank()) continue;
                args.add("GET");
                args.add(s);
            }
        }
        if (this.direction != null) {
            args.add(this.direction);
        }
        if (this.alpha) {
            args.add("ALPHA");
        }
        return args;
    }

    public static class Limit {
        private static final Limit NO_LIMIT = new Limit(-1L, -1L);
        private final long offset;
        private final long count;

        public static Limit of(long offset, long count) {
            return new Limit(offset, count);
        }

        public Limit(long offset, long count) {
            this.offset = offset;
            this.count = count;
        }

        public Limit(long count) {
            this(0L, count);
        }

        public static Limit noLimit() {
            return NO_LIMIT;
        }

        public List<String> toArgs() {
            if (this.offset == -1L && this.count == -1L) {
                return Collections.emptyList();
            }
            ArrayList<String> args = new ArrayList<String>();
            args.add("LIMIT");
            if (this.offset != -1L) {
                args.add(Long.toString(this.offset));
            }
            args.add(Long.toString(this.count));
            return args;
        }
    }
}

