/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.datasource.runtime;

import io.quarkus.credentials.CredentialsProvider;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.core.Future;
import io.vertx.sqlclient.SqlConnectOptions;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public class ConnectOptionsSupplier<CO extends SqlConnectOptions>
implements Supplier<Future<CO>> {
    private final CredentialsProvider credentialsProvider;
    private final String credentialsProviderName;
    private final List<CO> connectOptionsList;
    private final UnaryOperator<CO> connectOptionsCopy;
    private final AtomicInteger idx = new AtomicInteger();

    public ConnectOptionsSupplier(CredentialsProvider credentialsProvider, String credentialsProviderName, List<CO> connectOptionsList, UnaryOperator<CO> connectOptionsCopy) {
        this.credentialsProvider = credentialsProvider;
        this.credentialsProviderName = credentialsProviderName;
        this.connectOptionsList = connectOptionsList;
        this.connectOptionsCopy = connectOptionsCopy;
    }

    @Override
    public Future<CO> get() {
        int nextIdx = this.idx.getAndUpdate(previousIdx -> previousIdx == this.connectOptionsList.size() - 1 ? 0 : previousIdx + 1);
        SqlConnectOptions connectOptions = (SqlConnectOptions)this.connectOptionsCopy.apply((SqlConnectOptions)this.connectOptionsList.get(nextIdx));
        return (Future)Uni.combine().all().unis(this.credentialsProvider.getCredentialsAsync(this.credentialsProviderName), Uni.createFrom().item((Object)connectOptions)).with((credentials, co) -> {
            co.setUser((String)credentials.get("user"));
            co.setPassword((String)credentials.get("password"));
            return co;
        }).convert().with(UniHelper::toFuture);
    }
}

