/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.datasource.deployment;

import io.quarkus.arc.processor.DotNames;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.reactive.datasource.ReactiveDataSource;
import io.quarkus.reactive.datasource.deployment.ReactiveDataSourceDotNames;
import jakarta.enterprise.inject.Default;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public final class ReactiveDataSourceBuildUtil {
    public static final Type VERTX_POOL_TYPE = ClassType.create((DotName)ReactiveDataSourceDotNames.VERTX_POOL);

    private ReactiveDataSourceBuildUtil() {
    }

    public static AnnotationInstance qualifier(String dataSourceName) {
        if (dataSourceName == null || DataSourceUtil.isDefault((String)dataSourceName)) {
            return AnnotationInstance.builder(Default.class).build();
        }
        return AnnotationInstance.builder(ReactiveDataSource.class).value(dataSourceName).build();
    }

    public static AnnotationInstance[] qualifiers(String dataSourceName) {
        if (DataSourceUtil.isDefault((String)dataSourceName)) {
            return new AnnotationInstance[]{AnnotationInstance.builder(Default.class).build()};
        }
        return new AnnotationInstance[]{AnnotationInstance.builder((DotName)DotNames.NAMED).value(dataSourceName).build(), AnnotationInstance.builder(ReactiveDataSource.class).value(dataSourceName).build()};
    }
}

