/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactive.datasource.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.deployment.spi.DefaultDataSourceDbKindBuildItem;
import io.quarkus.datasource.runtime.DataSourceBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourcesBuildTimeConfig;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.reactive.datasource.ReactiveDataSource;
import io.quarkus.reactive.datasource.deployment.AggregatedDataSourceBuildTimeConfigBuildItem;
import io.quarkus.reactive.datasource.deployment.ReactiveDataSourceBuildItem;
import io.quarkus.reactive.datasource.runtime.DataSourceReactiveBuildTimeConfig;
import io.quarkus.reactive.datasource.runtime.DataSourcesReactiveBuildTimeConfig;
import io.quarkus.runtime.configuration.ConfigurationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jboss.logging.Logger;

class ReactiveDataSourceProcessor {
    private static final Logger log = Logger.getLogger(ReactiveDataSourceProcessor.class);

    ReactiveDataSourceProcessor() {
    }

    @BuildStep
    void addQualifierAsBean(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(ReactiveDataSource.class).build());
    }

    @BuildStep
    void build(DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesReactiveBuildTimeConfig dataSourcesReactiveBuildTimeConfig, List<DefaultDataSourceDbKindBuildItem> defaultDbKinds, BuildProducer<AggregatedDataSourceBuildTimeConfigBuildItem> aggregatedConfig, CurateOutcomeBuildItem curateOutcomeBuildItem) throws Exception {
        if (dataSourcesBuildTimeConfig.driver().isPresent() || dataSourcesBuildTimeConfig.url().isPresent()) {
            throw new ConfigurationException("quarkus.datasource.url and quarkus.datasource.driver have been deprecated in Quarkus 1.3 and removed in 1.9. Please use the new datasource configuration as explained in https://quarkus.io/guides/datasource.");
        }
        List<AggregatedDataSourceBuildTimeConfigBuildItem> aggregatedDataSourceBuildTimeConfigs = this.getAggregatedConfigBuildItems(dataSourcesBuildTimeConfig, dataSourcesReactiveBuildTimeConfig, curateOutcomeBuildItem, defaultDbKinds);
        if (aggregatedDataSourceBuildTimeConfigs.isEmpty()) {
            log.warn((Object)"The Datasource Reactive dependency is present but no Reactive datasources have been defined.");
            return;
        }
        for (AggregatedDataSourceBuildTimeConfigBuildItem aggregatedDataSourceBuildTimeConfig : aggregatedDataSourceBuildTimeConfigs) {
            aggregatedConfig.produce((BuildItem)aggregatedDataSourceBuildTimeConfig);
        }
    }

    private List<AggregatedDataSourceBuildTimeConfigBuildItem> getAggregatedConfigBuildItems(DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, DataSourcesReactiveBuildTimeConfig dataSourcesReactiveBuildTimeConfig, CurateOutcomeBuildItem curateOutcomeBuildItem, List<DefaultDataSourceDbKindBuildItem> defaultDbKinds) {
        ArrayList<AggregatedDataSourceBuildTimeConfigBuildItem> dataSources = new ArrayList<AggregatedDataSourceBuildTimeConfigBuildItem>();
        for (Map.Entry entry : dataSourcesBuildTimeConfig.dataSources().entrySet()) {
            DataSourceReactiveBuildTimeConfig reactiveBuildTimeConfig = ((DataSourcesReactiveBuildTimeConfig.DataSourceReactiveOuterNamedBuildTimeConfig)dataSourcesReactiveBuildTimeConfig.dataSources().get(entry.getKey())).reactive();
            if (!reactiveBuildTimeConfig.enabled()) continue;
            boolean enableImplicitResolution = DataSourceUtil.isDefault((String)((String)entry.getKey())) ? ((DataSourceBuildTimeConfig)entry.getValue()).devservices().enabled().orElse(!dataSourcesBuildTimeConfig.hasNamedDataSources()) : true;
            Optional effectiveDbKind = DefaultDataSourceDbKindBuildItem.resolve((Optional)((DataSourceBuildTimeConfig)entry.getValue()).dbKind(), defaultDbKinds, (boolean)enableImplicitResolution, (CurateOutcomeBuildItem)curateOutcomeBuildItem);
            if (effectiveDbKind.isEmpty()) continue;
            dataSources.add(new AggregatedDataSourceBuildTimeConfigBuildItem((String)entry.getKey(), (DataSourceBuildTimeConfig)entry.getValue(), reactiveBuildTimeConfig, (String)effectiveDbKind.get()));
        }
        return dataSources;
    }

    @BuildStep
    void produceReactiveDataSourceBuildItem(List<AggregatedDataSourceBuildTimeConfigBuildItem> aggregatedBuildTimeConfigBuildItems, BuildProducer<ReactiveDataSourceBuildItem> dataSource) {
        if (aggregatedBuildTimeConfigBuildItems.isEmpty()) {
            return;
        }
        for (AggregatedDataSourceBuildTimeConfigBuildItem aggregatedBuildTimeConfigBuildItem : aggregatedBuildTimeConfigBuildItems) {
            dataSource.produce((BuildItem)new ReactiveDataSourceBuildItem(aggregatedBuildTimeConfigBuildItem.getName(), aggregatedBuildTimeConfigBuildItem.getDbKind(), aggregatedBuildTimeConfigBuildItem.isDefault(), aggregatedBuildTimeConfigBuildItem.getDataSourceConfig().dbVersion()));
        }
    }
}

