/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.quartz.runtime;

import io.quarkus.quartz.runtime.QuartzMisfirePolicy;
import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigDocSection;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import io.smallrye.config.WithParentName;
import java.time.Duration;
import java.util.Map;

@ConfigRoot(phase=ConfigPhase.RUN_TIME)
@ConfigMapping(prefix="quarkus.quartz")
public interface QuartzRuntimeConfig {
    @WithDefault(value="QuarkusQuartzScheduler")
    public String instanceName();

    @WithDefault(value="AUTO")
    public String instanceId();

    @WithDefault(value="0")
    public long batchTriggerAcquisitionFireAheadTimeWindow();

    @WithDefault(value="1")
    public int batchTriggerAcquisitionMaxCount();

    @WithDefault(value="10")
    public int threadCount();

    @WithDefault(value="5")
    public int threadPriority();

    @WithDefault(value="60")
    public Duration misfireThreshold();

    @WithDefault(value="10")
    public Duration shutdownWaitTime();

    @WithName(value="simple-trigger")
    public TriggerConfig simpleTriggerConfig();

    @WithName(value="cron-trigger")
    public TriggerConfig cronTriggerConfig();

    @ConfigDocSection
    @ConfigDocMapKey(value="identity")
    @WithName(value="misfire-policy")
    public Map<String, QuartzMisfirePolicyConfig> misfirePolicyPerJobs();

    @ConfigDocMapKey(value="full-property-key")
    public Map<String, String> unsupportedProperties();

    @WithDefault(value="false")
    public boolean runBlockingScheduledMethodOnQuartzThread();

    public static interface TriggerConfig {
        @WithName(value="misfire-policy")
        public QuartzMisfirePolicyConfig misfirePolicyConfig();
    }

    public static interface QuartzMisfirePolicyConfig {
        @WithDefault(value="smart-policy")
        @WithParentName
        public QuartzMisfirePolicy misfirePolicy();
    }
}

