/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.IdGenerator;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import io.quarkus.arc.Arc;
import io.quarkus.opentelemetry.runtime.tracing.DelayedAttributes;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@Recorder
public class TracerRecorder {
    public static final Set<String> dropNonApplicationUriTargets = new HashSet<String>();
    public static final Set<String> dropStaticResourceTargets = new HashSet<String>();

    public RuntimeValue<Optional<IdGenerator>> createIdGenerator() {
        BeanManager beanManager = Arc.container().beanManager();
        Instance idGenerator = beanManager.createInstance().select(IdGenerator.class, new Annotation[]{Any.Literal.INSTANCE});
        return new RuntimeValue(idGenerator.isResolvable() ? Optional.of((IdGenerator)idGenerator.get()) : Optional.empty());
    }

    public RuntimeValue<Resource> createResource(String quarkusVersion, String serviceName, String serviceVersion) {
        BeanManager beanManager = Arc.container().beanManager();
        DelayedAttributes delayedAttributes = (DelayedAttributes)beanManager.createInstance().select(DelayedAttributes.class, new Annotation[]{Any.Literal.INSTANCE}).get();
        delayedAttributes.setAttributesDelegate(Resource.getDefault().merge(Resource.create((Attributes)Attributes.of((AttributeKey)ResourceAttributes.SERVICE_NAME, (Object)serviceName, (AttributeKey)ResourceAttributes.SERVICE_VERSION, (Object)serviceVersion, (AttributeKey)ResourceAttributes.WEBENGINE_NAME, (Object)"Quarkus", (AttributeKey)ResourceAttributes.WEBENGINE_VERSION, (Object)quarkusVersion))).getAttributes());
        return new RuntimeValue((Object)Resource.create((Attributes)delayedAttributes));
    }

    public RuntimeValue<List<SpanExporter>> createSpanExporter() {
        BeanManager beanManager = Arc.container().beanManager();
        Instance allExporters = beanManager.createInstance().select(SpanExporter.class, new Annotation[]{Any.Literal.INSTANCE});
        return new RuntimeValue(allExporters.stream().collect(Collectors.toList()));
    }

    public RuntimeValue<List<SpanProcessor>> createSpanProcessors() {
        BeanManager beanManager = Arc.container().beanManager();
        Instance allProcessors = beanManager.createInstance().select(SpanProcessor.class, new Annotation[]{Any.Literal.INSTANCE});
        return new RuntimeValue(allProcessors.stream().collect(Collectors.toList()));
    }

    public void setupSampler(List<String> dropNonApplicationUris, List<String> dropStaticResources) {
        dropNonApplicationUriTargets.addAll(dropNonApplicationUris);
        dropStaticResourceTargets.addAll(dropStaticResources);
    }
}

