/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.deployment.exporter.otlp;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.opentelemetry.runtime.config.build.OTelBuildConfig;
import io.quarkus.opentelemetry.runtime.config.build.exporter.OtlpExporterBuildConfig;
import io.quarkus.opentelemetry.runtime.config.runtime.OTelRuntimeConfig;
import io.quarkus.opentelemetry.runtime.config.runtime.exporter.OtlpExporterRuntimeConfig;
import io.quarkus.opentelemetry.runtime.exporter.otlp.OtlpExporterProvider;
import io.quarkus.opentelemetry.runtime.exporter.otlp.OtlpRecorder;
import java.util.function.BooleanSupplier;

@BuildSteps(onlyIf={OtlpExporterEnabled.class})
public class OtlpExporterProcessor {
    @BuildStep
    AdditionalBeanBuildItem createBatchSpanProcessor() {
        return AdditionalBeanBuildItem.builder().addBeanClass(OtlpExporterProvider.class).setUnremovable().build();
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void installBatchSpanProcessorForOtlp(OtlpRecorder recorder, LaunchModeBuildItem launchModeBuildItem, OTelRuntimeConfig otelRuntimeConfig, OtlpExporterRuntimeConfig exporterRuntimeConfig, BeanContainerBuildItem beanContainerBuildItem) {
        recorder.installBatchSpanProcessorForOtlp(otelRuntimeConfig, exporterRuntimeConfig, launchModeBuildItem.getLaunchMode());
    }

    static class OtlpExporterEnabled
    implements BooleanSupplier {
        OtlpExporterBuildConfig exportBuildConfig;
        OTelBuildConfig otelBuildConfig;

        OtlpExporterEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return this.otelBuildConfig.enabled() && this.otelBuildConfig.traces().enabled().orElse(Boolean.TRUE) != false && this.otelBuildConfig.traces().exporter().contains("cdi") && this.exportBuildConfig.enabled();
        }
    }
}

