/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.oidc.AccessTokenCredential;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.runtime.AbstractOidcAuthenticationMechanism;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.oidc.runtime.TrustStoreUtils;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.function.Function;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.jboss.logging.Logger;

public class BearerAuthenticationMechanism
extends AbstractOidcAuthenticationMechanism {
    private static final Logger LOG = Logger.getLogger(BearerAuthenticationMechanism.class);

    public Uni<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager, OidcTenantConfig oidcTenantConfig) {
        LOG.debug((Object)"Starting a bearer access token authentication");
        String token = OidcUtils.extractBearerToken(context, oidcTenantConfig);
        if (token != null) {
            try {
                BearerAuthenticationMechanism.setCertificateThumbprint(context, oidcTenantConfig);
            }
            catch (AuthenticationFailedException ex) {
                return Uni.createFrom().failure((Throwable)ex);
            }
            return this.authenticate(identityProviderManager, context, new AccessTokenCredential(token));
        }
        LOG.debug((Object)"Bearer access token is not available");
        return Uni.createFrom().nullItem();
    }

    private static void setCertificateThumbprint(RoutingContext context, OidcTenantConfig oidcTenantConfig) {
        if (oidcTenantConfig.token().binding().certificate()) {
            Certificate cert = BearerAuthenticationMechanism.getCertificate(context);
            if (!(cert instanceof X509Certificate)) {
                LOG.warn((Object)"Access token must be bound to X509 client certiifcate");
                throw new AuthenticationFailedException();
            }
            context.put("x5t#S256", (Object)TrustStoreUtils.calculateThumprint((X509Certificate)cert));
        }
    }

    private static Certificate getCertificate(RoutingContext context) {
        try {
            return context.request().sslSession().getPeerCertificates()[0];
        }
        catch (SSLPeerUnverifiedException e) {
            LOG.warn((Object)"Access token must be certificate bound but no client certificate is available");
            throw new AuthenticationFailedException();
        }
    }

    public Uni<ChallengeData> getChallenge(RoutingContext context) {
        Uni<TenantConfigContext> tenantContext = this.resolver.resolveContext(context);
        return tenantContext.onItem().transformToUni((Function)new Function<TenantConfigContext, Uni<? extends ChallengeData>>(){

            @Override
            public Uni<ChallengeData> apply(TenantConfigContext tenantContext) {
                return Uni.createFrom().item((Object)new ChallengeData(HttpResponseStatus.UNAUTHORIZED.code(), (CharSequence)HttpHeaderNames.WWW_AUTHENTICATE, tenantContext.oidcConfig().token().authorizationScheme()));
            }
        });
    }
}

