/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.deployment.devservices;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.RuntimeConfigSetupCompleteBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.devconsole.spi.DevConsoleRouteBuildItem;
import io.quarkus.devconsole.spi.DevConsoleRuntimeTemplateInfoBuildItem;
import io.quarkus.devconsole.spi.DevConsoleTemplateInfoBuildItem;
import io.quarkus.oidc.deployment.OidcBuildTimeConfig;
import io.quarkus.oidc.deployment.devservices.AbstractDevConsoleProcessor;
import io.quarkus.oidc.deployment.devservices.OidcAuthorizationCodePostHandler;
import io.quarkus.oidc.deployment.devservices.OidcDevServicesUtils;
import io.quarkus.oidc.deployment.devservices.OidcPasswordClientCredHandler;
import io.quarkus.oidc.deployment.devservices.OidcTestServiceHandler;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.util.Set;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public class OidcDevConsoleProcessor
extends AbstractDevConsoleProcessor {
    static volatile Vertx vertxInstance;
    private static final Logger LOG;
    private static final String TENANT_ENABLED_CONFIG_KEY = "quarkus.oidc.tenant-enabled";
    private static final String DISCOVERY_ENABLED_CONFIG_KEY = "quarkus.oidc.discovery-enabled";
    private static final String AUTH_SERVER_URL_CONFIG_KEY = "quarkus.oidc.auth-server-url";
    private static final String APP_TYPE_CONFIG_KEY = "quarkus.oidc.application-type";
    private static final String SERVICE_APP_TYPE = "service";
    private static final String KEYCLOAK = "Keycloak";
    private static final String AZURE = "Azure";
    private static final Set<String> OTHER_PROVIDERS;
    OidcBuildTimeConfig oidcConfig;

    @BuildStep(onlyIf={IsDevelopment.class})
    @Consume(value=RuntimeConfigSetupCompleteBuildItem.class)
    void prepareOidcDevConsole(BuildProducer<DevConsoleTemplateInfoBuildItem> devConsoleInfo, BuildProducer<DevConsoleRuntimeTemplateInfoBuildItem> devConsoleRuntimeInfo, CuratedApplicationShutdownBuildItem closeBuildItem, BuildProducer<DevConsoleRouteBuildItem> devConsoleRoute, Capabilities capabilities, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        if (OidcDevConsoleProcessor.isOidcTenantEnabled() && OidcDevConsoleProcessor.isAuthServerUrlSet() && OidcDevConsoleProcessor.isClientIdSet()) {
            if (vertxInstance == null) {
                vertxInstance = Vertx.vertx();
                Runnable closeTask = new Runnable(){

                    @Override
                    public void run() {
                        if (vertxInstance != null) {
                            try {
                                vertxInstance.close();
                            }
                            catch (Throwable t) {
                                LOG.error((Object)"Failed to close Vertx instance", t);
                            }
                        }
                        vertxInstance = null;
                    }
                };
                closeBuildItem.addCloseTask(closeTask, true);
            }
            String authServerUrl = null;
            try {
                authServerUrl = this.getConfigProperty(AUTH_SERVER_URL_CONFIG_KEY);
            }
            catch (Exception ex) {
                return;
            }
            JsonObject metadata = null;
            if (OidcDevConsoleProcessor.isDiscoveryEnabled() && (metadata = this.discoverMetadata(authServerUrl)) == null) {
                return;
            }
            String providerName = this.tryToGetProviderName(authServerUrl);
            if (KEYCLOAK.equals(providerName)) {
                devConsoleInfo.produce((BuildItem)new DevConsoleTemplateInfoBuildItem("keycloakAdminUrl", (Object)authServerUrl.substring(0, authServerUrl.indexOf("/realms/"))));
            }
            this.produceDevConsoleTemplateItems(capabilities, devConsoleInfo, devConsoleRuntimeInfo, curateOutcomeBuildItem, providerName, OidcDevConsoleProcessor.getApplicationType(), this.oidcConfig.devui.grant.type.isPresent() ? this.oidcConfig.devui.grant.type.get().getGrantType() : "code", metadata != null ? metadata.getString("authorization_endpoint") : null, metadata != null ? metadata.getString("token_endpoint") : null, metadata != null ? metadata.getString("end_session_endpoint") : null, metadata != null ? metadata.containsKey("introspection_endpoint") : false);
            this.produceDevConsoleRouteItems(devConsoleRoute, new OidcTestServiceHandler(vertxInstance, this.oidcConfig.devui.webClientTimeout), new OidcAuthorizationCodePostHandler(vertxInstance, this.oidcConfig.devui.webClientTimeout, this.oidcConfig.devui.grantOptions), new OidcPasswordClientCredHandler(vertxInstance, this.oidcConfig.devui.webClientTimeout, this.oidcConfig.devui.grantOptions));
        }
    }

    private String tryToGetProviderName(String authServerUrl) {
        if (authServerUrl.contains("/realms/")) {
            return KEYCLOAK;
        }
        if (authServerUrl.contains("microsoft")) {
            return AZURE;
        }
        for (String provider : OTHER_PROVIDERS) {
            if (!authServerUrl.contains(provider.toLowerCase())) continue;
            return provider;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonObject discoverMetadata(String authServerUrl) {
        try (WebClient client = OidcDevServicesUtils.createWebClient(vertxInstance);){
            String metadataUrl = authServerUrl + "/.well-known/openid-configuration";
            LOG.infof("OIDC Dev Console: discovering the provider metadata at %s", (Object)metadataUrl);
            HttpResponse resp = (HttpResponse)client.getAbs(metadataUrl).putHeader(HttpHeaders.ACCEPT.toString(), "application/json").send().await().indefinitely();
            if (resp.statusCode() == 200) {
                JsonObject jsonObject = resp.bodyAsJsonObject();
                return jsonObject;
            }
            LOG.errorf("OIDC metadata discovery failed: %s", (Object)resp.bodyAsString());
            JsonObject jsonObject = null;
            return jsonObject;
        }
    }

    private String getConfigProperty(String name) {
        return (String)ConfigProvider.getConfig().getValue(name, String.class);
    }

    private static boolean isOidcTenantEnabled() {
        return OidcDevConsoleProcessor.getBooleanProperty(TENANT_ENABLED_CONFIG_KEY);
    }

    private static boolean isDiscoveryEnabled() {
        return OidcDevConsoleProcessor.getBooleanProperty(DISCOVERY_ENABLED_CONFIG_KEY);
    }

    private static boolean getBooleanProperty(String name) {
        return ConfigProvider.getConfig().getOptionalValue(name, Boolean.class).orElse(true);
    }

    private static boolean isClientIdSet() {
        return ConfigUtils.isPropertyPresent((String)"quarkus.oidc.client-id");
    }

    private static boolean isAuthServerUrlSet() {
        return ConfigUtils.isPropertyPresent((String)AUTH_SERVER_URL_CONFIG_KEY);
    }

    private static String getApplicationType() {
        return ConfigProvider.getConfig().getOptionalValue(APP_TYPE_CONFIG_KEY, String.class).orElse(SERVICE_APP_TYPE);
    }

    static {
        LOG = Logger.getLogger(OidcDevConsoleProcessor.class);
        OTHER_PROVIDERS = Set.of("Auth0", "Okta", "Google");
    }
}

