/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.observability.testcontainers;

import io.quarkus.observability.common.config.GrafanaConfig;
import io.quarkus.observability.testcontainers.ObservabilityContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public abstract class GrafanaContainer<T extends GrafanaContainer<T, C>, C extends GrafanaConfig>
extends ObservabilityContainer<T, C> {
    protected C config;

    public GrafanaContainer(C config) {
        super(config);
        this.config = config;
        this.withEnv("GF_SECURITY_ADMIN_USER", config.username());
        this.withEnv("GF_SECURITY_ADMIN_PASSWORD", config.password());
        this.addExposedPort(3000);
        config.grafanaPort().ifPresent(port -> this.addFixedExposedPort(port, 3000));
        this.waitingFor(this.waitStrategy());
    }

    public int getGrafanaPort() {
        return this.getMappedPort(3000);
    }

    protected WaitStrategy waitStrategy() {
        return Wait.forHttp((String)"/").forPort(3000).forStatusCode(200).withStartupTimeout(this.config.timeout());
    }
}

