/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.observability.devresource.testcontainers;

import io.quarkus.devservices.common.ContainerShutdownCloseable;
import io.quarkus.observability.common.config.ContainerConfig;
import io.quarkus.observability.devresource.Container;
import java.io.Closeable;
import java.time.Duration;
import java.util.Objects;
import org.testcontainers.containers.GenericContainer;

public class TestcontainerContainer<C extends GenericContainer<C>, T extends ContainerConfig>
implements Container<T> {
    private final GenericContainer<C> container;

    public TestcontainerContainer(GenericContainer<C> container) {
        this.container = Objects.requireNonNull(container);
    }

    public void start() {
        this.container.start();
    }

    public void stop() {
        this.container.stop();
    }

    public String getContainerId() {
        return this.container.getContainerId();
    }

    public void withStartupTimeout(Duration duration) {
        this.container.withStartupTimeout(duration);
    }

    public Closeable closeableCallback(String serviceName) {
        return new ContainerShutdownCloseable(this.container, serviceName);
    }
}

