/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.panache.deployment;

import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.deployment.staticmethods.InterceptedStaticMethodsTransformersRegisteredBuildItem;
import io.quarkus.builder.BuildException;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.bean.JavaBeanUtil;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyIgnoreWarningBuildItem;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.jackson.spi.JacksonModuleBuildItem;
import io.quarkus.jsonb.spi.JsonbDeserializerBuildItem;
import io.quarkus.jsonb.spi.JsonbSerializerBuildItem;
import io.quarkus.mongodb.deployment.MongoClientNameBuildItem;
import io.quarkus.mongodb.deployment.MongoUnremovableClientsBuildItem;
import io.quarkus.mongodb.panache.common.MongoDatabaseResolver;
import io.quarkus.mongodb.panache.common.MongoEntity;
import io.quarkus.mongodb.panache.common.PanacheMongoRecorder;
import io.quarkus.mongodb.panache.common.ProjectionFor;
import io.quarkus.mongodb.panache.common.jsonb.ObjectIdDeserializer;
import io.quarkus.mongodb.panache.common.jsonb.ObjectIdSerializer;
import io.quarkus.mongodb.panache.deployment.PanacheMongoEntityClassBuildItem;
import io.quarkus.mongodb.panache.deployment.ProjectionForEnhancer;
import io.quarkus.mongodb.panache.deployment.PropertyMappingClassBuildStep;
import io.quarkus.panache.common.deployment.EntityField;
import io.quarkus.panache.common.deployment.EntityModel;
import io.quarkus.panache.common.deployment.MetamodelInfo;
import io.quarkus.panache.common.deployment.PanacheEntityClassesBuildItem;
import io.quarkus.panache.common.deployment.PanacheEntityEnhancer;
import io.quarkus.panache.common.deployment.PanacheFieldAccessEnhancer;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizer;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizerBuildItem;
import io.quarkus.panache.common.deployment.PanacheRepositoryEnhancer;
import io.quarkus.panache.common.deployment.TypeBundle;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.bson.codecs.pojo.annotations.BsonId;
import org.bson.codecs.pojo.annotations.BsonIgnore;
import org.bson.codecs.pojo.annotations.BsonProperty;
import org.bson.types.ObjectId;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public abstract class BasePanacheMongoResourceProcessor {
    public static final DotName BSON_ID = DotName.createSimple((String)BsonId.class.getName());
    public static final DotName BSON_IGNORE = DotName.createSimple((String)BsonIgnore.class.getName());
    public static final DotName BSON_PROPERTY = DotName.createSimple((String)BsonProperty.class.getName());
    public static final DotName MONGO_DATABASE_RESOLVER = DotName.createSimple((String)MongoDatabaseResolver.class.getName());
    public static final DotName MONGO_ENTITY = DotName.createSimple((String)MongoEntity.class.getName());
    public static final DotName PROJECTION_FOR = DotName.createSimple((String)ProjectionFor.class.getName());
    public static final String BSON_PACKAGE = "org.bson.";

    @BuildStep
    @Consume(value=InterceptedStaticMethodsTransformersRegisteredBuildItem.class)
    public void buildImperative(CombinedIndexBuildItem index, BuildProducer<BytecodeTransformerBuildItem> transformers, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, BuildProducer<PropertyMappingClassBuildStep> propertyMappingClass, List<PanacheMethodCustomizerBuildItem> methodCustomizersBuildItems) {
        List<PanacheMethodCustomizer> methodCustomizers = methodCustomizersBuildItems.stream().map(PanacheMethodCustomizerBuildItem::getMethodCustomizer).collect(Collectors.toList());
        MetamodelInfo modelInfo = new MetamodelInfo();
        this.processTypes(index, transformers, reflectiveClass, reflectiveHierarchy, propertyMappingClass, this.getImperativeTypeBundle(), this.createRepositoryEnhancer(index, methodCustomizers), this.createEntityEnhancer(index, methodCustomizers, modelInfo), modelInfo);
    }

    @BuildStep
    @Consume(value=InterceptedStaticMethodsTransformersRegisteredBuildItem.class)
    public void buildReactive(CombinedIndexBuildItem index, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, BuildProducer<PropertyMappingClassBuildStep> propertyMappingClass, BuildProducer<BytecodeTransformerBuildItem> transformers, List<PanacheMethodCustomizerBuildItem> methodCustomizersBuildItems) {
        List<PanacheMethodCustomizer> methodCustomizers = methodCustomizersBuildItems.stream().map(PanacheMethodCustomizerBuildItem::getMethodCustomizer).collect(Collectors.toList());
        MetamodelInfo modelInfo = new MetamodelInfo();
        this.processTypes(index, transformers, reflectiveClass, reflectiveHierarchy, propertyMappingClass, this.getReactiveTypeBundle(), this.createReactiveRepositoryEnhancer(index, methodCustomizers), this.createReactiveEntityEnhancer(index, methodCustomizers, modelInfo), modelInfo);
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    protected void buildReplacementMap(List<PropertyMappingClassBuildStep> propertyMappingClasses, CombinedIndexBuildItem index, PanacheMongoRecorder recorder) {
        ConcurrentHashMap<String, Map> replacementMap = new ConcurrentHashMap<String, Map>();
        for (PropertyMappingClassBuildStep classToMap : propertyMappingClasses) {
            DotName dotName = DotName.createSimple((String)classToMap.getClassName());
            ClassInfo classInfo = index.getComputingIndex().getClassByName(dotName);
            if (classInfo == null) continue;
            Map classReplacementMap = replacementMap.computeIfAbsent(classToMap.getClassName(), className -> this.computeReplacement(classInfo));
            if (classToMap.getAliasClassName() == null) continue;
            replacementMap.put(classToMap.getAliasClassName(), classReplacementMap);
        }
        recorder.setReplacementCache(replacementMap);
    }

    private Map<String, String> computeReplacement(ClassInfo classInfo) {
        AnnotationInstance bsonProperty;
        HashMap<String, String> replacementMap = new HashMap<String, String>();
        for (FieldInfo field : classInfo.fields()) {
            bsonProperty = field.annotation(BSON_PROPERTY);
            if (bsonProperty == null) continue;
            replacementMap.put(field.name(), bsonProperty.value().asString());
        }
        for (MethodInfo method : classInfo.methods()) {
            if (!method.name().startsWith("get") || (bsonProperty = method.annotation(BSON_PROPERTY)) == null) continue;
            String fieldName = JavaBeanUtil.decapitalize((String)method.name().substring(3));
            replacementMap.put(fieldName, bsonProperty.value().asString());
        }
        return replacementMap.isEmpty() ? Collections.emptyMap() : replacementMap;
    }

    protected abstract PanacheEntityEnhancer createEntityEnhancer(CombinedIndexBuildItem var1, List<PanacheMethodCustomizer> var2, MetamodelInfo var3);

    protected abstract PanacheEntityEnhancer createReactiveEntityEnhancer(CombinedIndexBuildItem var1, List<PanacheMethodCustomizer> var2, MetamodelInfo var3);

    protected abstract PanacheRepositoryEnhancer createReactiveRepositoryEnhancer(CombinedIndexBuildItem var1, List<PanacheMethodCustomizer> var2);

    protected abstract PanacheRepositoryEnhancer createRepositoryEnhancer(CombinedIndexBuildItem var1, List<PanacheMethodCustomizer> var2);

    private void extractMappings(Map<String, String> classPropertyMapping, ClassInfo target, CombinedIndexBuildItem index) {
        AnnotationInstance bsonProperty;
        for (FieldInfo fieldInfo : target.fields()) {
            if (!fieldInfo.hasAnnotation(BSON_PROPERTY)) continue;
            bsonProperty = fieldInfo.annotation(BSON_PROPERTY);
            classPropertyMapping.put(fieldInfo.name(), bsonProperty.value().asString());
        }
        for (MethodInfo methodInfo : target.methods()) {
            if (!methodInfo.hasAnnotation(BSON_PROPERTY)) continue;
            bsonProperty = methodInfo.annotation(BSON_PROPERTY);
            classPropertyMapping.put(methodInfo.name(), bsonProperty.value().asString());
        }
        if (!target.superClassType().name().equals((Object)JandexUtil.DOTNAME_OBJECT)) {
            Type superType = target.superClassType();
            ClassInfo superClass = index.getComputingIndex().getClassByName(superType.name());
            this.extractMappings(classPropertyMapping, superClass, index);
        }
    }

    @BuildStep
    protected PanacheEntityClassesBuildItem findEntityClasses(List<PanacheMongoEntityClassBuildItem> entityClasses) {
        if (!entityClasses.isEmpty()) {
            HashSet<String> ret = new HashSet<String>();
            for (PanacheMongoEntityClassBuildItem entityClass : entityClasses) {
                ret.add(entityClass.get().name().toString());
            }
            return new PanacheEntityClassesBuildItem(ret);
        }
        return null;
    }

    protected abstract TypeBundle getImperativeTypeBundle();

    protected abstract TypeBundle getReactiveTypeBundle();

    @BuildStep
    protected void handleProjectionFor(CombinedIndexBuildItem index, BuildProducer<PropertyMappingClassBuildStep> propertyMappingClass, BuildProducer<BytecodeTransformerBuildItem> transformers) {
        Type targetClass;
        HashMap<DotName, HashMap<String, String>> propertyMapping = new HashMap<DotName, HashMap<String, String>>();
        for (AnnotationInstance annotationInstance : index.getComputingIndex().getAnnotations(PROJECTION_FOR)) {
            targetClass = annotationInstance.value().asClass();
            ClassInfo target = index.getComputingIndex().getClassByName(targetClass.name());
            HashMap<String, String> classPropertyMapping = new HashMap<String, String>();
            this.extractMappings(classPropertyMapping, target, index);
            propertyMapping.put(targetClass.name(), classPropertyMapping);
        }
        for (AnnotationInstance annotationInstance : index.getComputingIndex().getAnnotations(PROJECTION_FOR)) {
            targetClass = annotationInstance.value().asClass();
            Map targetPropertyMapping = (Map)propertyMapping.get(targetClass.name());
            if (targetPropertyMapping != null && !targetPropertyMapping.isEmpty()) {
                ClassInfo info = annotationInstance.target().asClass();
                ProjectionForEnhancer fieldEnhancer = new ProjectionForEnhancer(targetPropertyMapping);
                transformers.produce((BuildItem)new BytecodeTransformerBuildItem(info.name().toString(), (BiFunction)fieldEnhancer));
            }
            propertyMappingClass.produce((BuildItem)new PropertyMappingClassBuildStep(targetClass.name().toString(), annotationInstance.target().asClass().name().toString()));
        }
    }

    @BuildStep
    public void mongoClientNames(ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<MongoClientNameBuildItem> mongoClientName) {
        HashSet<String> values = new HashSet<String>();
        IndexView indexView = applicationArchivesBuildItem.getRootArchive().getIndex();
        Collection instances = indexView.getAnnotations(MONGO_ENTITY);
        for (AnnotationInstance annotation : instances) {
            AnnotationValue clientName = annotation.value("clientName");
            if (clientName == null || clientName.asString().isEmpty()) continue;
            values.add(clientName.asString());
        }
        for (String value : values) {
            mongoClientName.produce((BuildItem)new MongoClientNameBuildItem(value, false));
        }
    }

    protected void processEntities(CombinedIndexBuildItem index, BuildProducer<BytecodeTransformerBuildItem> transformers, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<PropertyMappingClassBuildStep> propertyMappingClass, PanacheEntityEnhancer entityEnhancer, TypeBundle typeBundle, MetamodelInfo modelInfo) {
        HashSet<String> modelClasses = new HashSet<String>();
        for (ClassInfo classInfo : index.getComputingIndex().getAllKnownSubclasses(typeBundle.entityBase().dotName())) {
            if (classInfo.name().equals((Object)typeBundle.entity().dotName()) || !modelClasses.add(classInfo.name().toString())) continue;
            modelInfo.addEntityModel(this.createEntityModel(classInfo));
        }
        for (ClassInfo classInfo : index.getComputingIndex().getAllKnownSubclasses(typeBundle.entity().dotName())) {
            if (!modelClasses.add(classInfo.name().toString())) continue;
            modelInfo.addEntityModel(this.createEntityModel(classInfo));
        }
        for (String modelClass : modelClasses) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(modelClass, (BiFunction)entityEnhancer));
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{modelClass}).fields().methods().build());
            propertyMappingClass.produce((BuildItem)new PropertyMappingClassBuildStep(modelClass));
        }
        this.replaceFieldAccesses(index, transformers, modelInfo);
    }

    private void replaceFieldAccesses(CombinedIndexBuildItem index, BuildProducer<BytecodeTransformerBuildItem> transformers, MetamodelInfo modelInfo) {
        Set entitiesWithExternallyAccessibleFields = modelInfo.getEntitiesWithExternallyAccessibleFields();
        if (entitiesWithExternallyAccessibleFields.isEmpty()) {
            return;
        }
        HashSet<String> entityClassNamesInternal = new HashSet<String>();
        for (String entityClassName : entitiesWithExternallyAccessibleFields) {
            entityClassNamesInternal.add(entityClassName.replace(".", "/"));
        }
        PanacheFieldAccessEnhancer panacheFieldAccessEnhancer = new PanacheFieldAccessEnhancer(modelInfo);
        HashSet<String> produced = new HashSet<String>();
        for (String entityClassName : entitiesWithExternallyAccessibleFields) {
            for (ClassInfo userClass : index.getIndex().getKnownUsers(entityClassName)) {
                String cn = userClass.name().toString('.');
                if (produced.contains(cn)) continue;
                produced.add(cn);
                transformers.produce((BuildItem)new BytecodeTransformerBuildItem(cn, (BiFunction)panacheFieldAccessEnhancer, entityClassNamesInternal));
            }
        }
    }

    private EntityModel createEntityModel(ClassInfo classInfo) {
        EntityModel entityModel = new EntityModel(classInfo);
        for (FieldInfo fieldInfo : classInfo.fields()) {
            String name = fieldInfo.name();
            EntityField.Visibility visibility = EntityField.Visibility.get((int)fieldInfo.flags());
            if (!EntityField.Visibility.PUBLIC.equals((Object)visibility) || Modifier.isStatic(fieldInfo.flags()) || fieldInfo.hasAnnotation(BSON_IGNORE)) continue;
            entityModel.addField(new EntityField(name, DescriptorUtils.typeToString((Type)fieldInfo.type()), visibility));
        }
        return entityModel;
    }

    protected void processRepositories(CombinedIndexBuildItem index, BuildProducer<BytecodeTransformerBuildItem> transformers, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, BuildProducer<PropertyMappingClassBuildStep> propertyMappingClass, PanacheRepositoryEnhancer repositoryEnhancer, TypeBundle typeBundle) {
        HashSet<String> daoClasses = new HashSet<String>();
        HashSet daoTypeParameters = new HashSet();
        DotName dotName = typeBundle.repositoryBase().dotName();
        for (ClassInfo classInfo : index.getComputingIndex().getAllKnownImplementors(dotName)) {
            if (classInfo.name().equals((Object)typeBundle.repository().dotName()) || repositoryEnhancer.skipRepository(classInfo)) continue;
            daoClasses.add(classInfo.name().toString());
            daoTypeParameters.addAll(JandexUtil.resolveTypeParameters((DotName)classInfo.name(), (DotName)typeBundle.repositoryBase().dotName(), (IndexView)index.getComputingIndex()));
        }
        for (ClassInfo classInfo : index.getComputingIndex().getAllKnownImplementors(typeBundle.repository().dotName())) {
            if (repositoryEnhancer.skipRepository(classInfo)) continue;
            daoClasses.add(classInfo.name().toString());
            daoTypeParameters.addAll(JandexUtil.resolveTypeParameters((DotName)classInfo.name(), (DotName)typeBundle.repositoryBase().dotName(), (IndexView)index.getComputingIndex()));
        }
        for (String daoClass : daoClasses) {
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(daoClass, (BiFunction)repositoryEnhancer));
        }
        for (Type parameterType : daoTypeParameters) {
            reflectiveHierarchy.produce((BuildItem)ReflectiveHierarchyBuildItem.builder((Type)parameterType).build());
            propertyMappingClass.produce((BuildItem)new PropertyMappingClassBuildStep(parameterType.name().toString()));
        }
    }

    protected void processTypes(CombinedIndexBuildItem index, BuildProducer<BytecodeTransformerBuildItem> transformers, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, BuildProducer<PropertyMappingClassBuildStep> propertyMappingClass, TypeBundle typeBundle, PanacheRepositoryEnhancer repositoryEnhancer, PanacheEntityEnhancer entityEnhancer, MetamodelInfo modelInfo) {
        this.processRepositories(index, transformers, reflectiveHierarchy, propertyMappingClass, repositoryEnhancer, typeBundle);
        this.processEntities(index, transformers, reflectiveClass, propertyMappingClass, entityEnhancer, typeBundle, modelInfo);
    }

    @BuildStep
    ReflectiveHierarchyIgnoreWarningBuildItem ignoreBsonTypes() {
        return new ReflectiveHierarchyIgnoreWarningBuildItem(dotname -> dotname.toString().startsWith(BSON_PACKAGE));
    }

    @BuildStep
    protected void registerJacksonSerDeser(BuildProducer<JacksonModuleBuildItem> customSerDeser) {
        customSerDeser.produce((BuildItem)new JacksonModuleBuildItem.Builder("ObjectIdModule").add(io.quarkus.mongodb.panache.common.jackson.ObjectIdSerializer.class.getName(), io.quarkus.mongodb.panache.common.jackson.ObjectIdDeserializer.class.getName(), ObjectId.class.getName()).build());
    }

    @BuildStep
    protected void registerJsonbSerDeser(BuildProducer<JsonbSerializerBuildItem> jsonbSerializers, BuildProducer<JsonbDeserializerBuildItem> jsonbDeserializers) {
        jsonbSerializers.produce((BuildItem)new JsonbSerializerBuildItem(ObjectIdSerializer.class.getName()));
        jsonbDeserializers.produce((BuildItem)new JsonbDeserializerBuildItem(ObjectIdDeserializer.class.getName()));
    }

    @BuildStep
    public void unremovableClients(BuildProducer<MongoUnremovableClientsBuildItem> unremovable) {
        unremovable.produce((BuildItem)new MongoUnremovableClientsBuildItem());
    }

    @BuildStep
    protected void unremovableMongoDatabaseResolvers(BuildProducer<UnremovableBeanBuildItem> unremovable) {
        unremovable.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((DotName[])new DotName[]{MONGO_DATABASE_RESOLVER}));
    }

    @BuildStep
    protected ValidationPhaseBuildItem.ValidationErrorBuildItem validate(ValidationPhaseBuildItem validationPhase, CombinedIndexBuildItem index) throws BuildException {
        for (AnnotationInstance annotationInstance : index.getComputingIndex().getAnnotations(BSON_ID)) {
            ClassInfo info = JandexUtil.getEnclosingClass((AnnotationInstance)annotationInstance);
            if (JandexUtil.isSubclassOf((IndexView)index.getComputingIndex(), (ClassInfo)info, (DotName)this.getImperativeTypeBundle().entity().dotName())) {
                BuildException be = new BuildException("You provide a MongoDB identifier via @BsonId inside '" + String.valueOf(info.name()) + "' but one is already provided by PanacheMongoEntity, your class should extend PanacheMongoEntityBase instead, or use the id provided by PanacheMongoEntity", Collections.emptyList());
                return new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{be});
            }
            if (!JandexUtil.isSubclassOf((IndexView)index.getComputingIndex(), (ClassInfo)info, (DotName)this.getReactiveTypeBundle().entity().dotName())) continue;
            BuildException be = new BuildException("You provide a MongoDB identifier via @BsonId inside '" + String.valueOf(info.name()) + "' but one is already provided by ReactivePanacheMongoEntity, your class should extend ReactivePanacheMongoEntityBase instead, or use the id provided by ReactivePanacheMongoEntity", Collections.emptyList());
            return new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{be});
        }
        return null;
    }
}

