/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.runtime;

import io.quarkus.mongodb.runtime.CredentialConfig;
import io.quarkus.mongodb.runtime.WriteConcernConfig;
import io.quarkus.runtime.annotations.ConfigDocSection;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import org.bson.UuidRepresentation;

@ConfigGroup
public interface MongoClientConfig {
    public Optional<String> connectionString();

    @WithDefault(value="127.0.0.1:27017")
    public List<String> hosts();

    public Optional<String> database();

    public Optional<String> applicationName();

    public OptionalInt maxPoolSize();

    public OptionalInt minPoolSize();

    public Optional<Duration> maxConnectionIdleTime();

    public Optional<Duration> maxConnectionLifeTime();

    public Optional<Duration> maintenanceFrequency();

    public Optional<Duration> maintenanceInitialDelay();

    public Optional<Duration> connectTimeout();

    public Optional<Duration> readTimeout();

    @WithDefault(value="false")
    @Deprecated(forRemoval=true, since="3.21")
    public boolean tlsInsecure();

    @WithDefault(value="false")
    public boolean tls();

    public Optional<String> tlsConfigurationName();

    public Optional<String> replicaSetName();

    public Optional<Duration> serverSelectionTimeout();

    public Optional<Duration> localThreshold();

    public Optional<Duration> heartbeatFrequency();

    @ConfigDocSection
    public WriteConcernConfig writeConcern();

    public Optional<String> readConcern();

    public Optional<String> readPreference();

    @ConfigDocSection
    public CredentialConfig credentials();

    @WithName(value="health.database")
    @WithDefault(value="admin")
    public String healthDatabase();

    public Optional<UuidRepresentation> uuidRepresentation();

    @WithDefault(value="netty")
    public ReactiveTransportConfig reactiveTransport();

    public static enum ReactiveTransportConfig {
        NETTY,
        MONGO;

    }
}

