/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.deployment;

import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.message.BasicNameValuePair;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.net.URLEncodedUtils;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.mongodb.deployment.DevServicesBuildTimeConfig;
import io.quarkus.mongodb.deployment.MongoClientBuildTimeConfig;
import io.quarkus.mongodb.deployment.MongoConnectionNameBuildItem;
import io.quarkus.mongodb.runtime.MongoClientBeanUtil;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.io.Closeable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.MongoDBContainer;
import org.testcontainers.utility.DockerImageName;

@BuildSteps(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
public class DevServicesMongoProcessor {
    private static final Logger log = Logger.getLogger(DevServicesMongoProcessor.class);
    static volatile List<DevServicesResultBuildItem.RunningDevService> devServices;
    static volatile Map<String, CapturedProperties> capturedProperties;
    static volatile boolean first;
    private static final String MONGO_SCHEME = "mongodb://";
    private static final int MONGO_EXPOSED_PORT = 27017;
    private static final String DEV_SERVICE_LABEL = "quarkus-dev-service-mongodb";
    private static final ContainerLocator MONGO_CONTAINER_LOCATOR;

    @BuildStep
    public List<DevServicesResultBuildItem> startMongo(List<MongoConnectionNameBuildItem> mongoConnections, DockerStatusBuildItem dockerStatusBuildItem, MongoClientBuildTimeConfig mongoClientBuildTimeConfig, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, CuratedApplicationShutdownBuildItem closeBuildItem, LaunchModeBuildItem launchMode, LoggingSetupBuildItem loggingSetupBuildItem, GlobalDevServicesConfig globalDevServicesConfig) {
        ArrayList<String> connectionNames = new ArrayList<String>(mongoConnections.size());
        for (MongoConnectionNameBuildItem mongoConnection : mongoConnections) {
            connectionNames.add(mongoConnection.getName());
        }
        Map<String, CapturedProperties> currentCapturedProperties = this.captureProperties(connectionNames, mongoClientBuildTimeConfig);
        if (devServices != null) {
            boolean restartRequired;
            boolean bl = restartRequired = !currentCapturedProperties.equals(capturedProperties);
            if (!restartRequired) {
                return devServices.stream().map(DevServicesResultBuildItem.RunningDevService::toBuildItem).collect(Collectors.toList());
            }
            for (Closeable closeable : devServices) {
                try {
                    closeable.close();
                }
                catch (Throwable e) {
                    log.error((Object)"Failed to stop database", e);
                }
            }
            devServices = null;
            capturedProperties = null;
        }
        ArrayList<DevServicesResultBuildItem.RunningDevService> newDevServices = new ArrayList<DevServicesResultBuildItem.RunningDevService>(mongoConnections.size());
        for (String string : connectionNames) {
            StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "Mongo Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
            try {
                boolean useSharedNetwork = DevServicesSharedNetworkBuildItem.isSharedNetworkRequired((GlobalDevServicesConfig)globalDevServicesConfig, devServicesSharedNetworkBuildItem);
                DevServicesResultBuildItem.RunningDevService devService = this.startMongo(dockerStatusBuildItem, string, currentCapturedProperties.get(string), useSharedNetwork, globalDevServicesConfig.timeout, launchMode.getLaunchMode());
                if (devService == null) {
                    compressor.closeAndDumpCaptured();
                    continue;
                }
                compressor.close();
                newDevServices.add(devService);
            }
            catch (Throwable t) {
                compressor.closeAndDumpCaptured();
                throw new RuntimeException(t);
            }
        }
        if (first) {
            first = false;
            Runnable closeTask = new Runnable(){

                @Override
                public void run() {
                    if (devServices != null) {
                        for (Closeable closeable : devServices) {
                            try {
                                closeable.close();
                            }
                            catch (Throwable t) {
                                log.error((Object)"Failed to stop database", t);
                            }
                        }
                    }
                    first = true;
                    devServices = null;
                    capturedProperties = null;
                }
            };
            closeBuildItem.addCloseTask(closeTask, true);
        }
        devServices = newDevServices;
        capturedProperties = currentCapturedProperties;
        return devServices.stream().map(DevServicesResultBuildItem.RunningDevService::toBuildItem).collect(Collectors.toList());
    }

    private DevServicesResultBuildItem.RunningDevService startMongo(DockerStatusBuildItem dockerStatusBuildItem, String connectionName, CapturedProperties capturedProperties, boolean useSharedNetwork, Optional<Duration> timeout, LaunchMode launchMode) {
        boolean needToStart;
        if (!capturedProperties.devServicesEnabled) {
            log.debug((Object)("Not starting devservices for " + (MongoClientBeanUtil.isDefault((String)connectionName) ? "default datasource" : connectionName) + " as it has been disabled in the config"));
            return null;
        }
        String configPrefix = this.getConfigPrefix(connectionName);
        boolean bl = needToStart = !ConfigUtils.isPropertyPresent((String)(configPrefix + "connection-string"));
        if (!needToStart) {
            log.debug((Object)("Not starting devservices for " + (MongoClientBeanUtil.isDefault((String)connectionName) ? "default datasource" : connectionName) + " as a connection string has been provided"));
            return null;
        }
        if (!dockerStatusBuildItem.isDockerAvailable()) {
            log.warn((Object)("Please configure datasource URL for " + (MongoClientBeanUtil.isDefault((String)connectionName) ? "default datasource" : connectionName) + " or get a working docker instance"));
            return null;
        }
        Supplier<DevServicesResultBuildItem.RunningDevService> defaultMongoServerSupplier = () -> {
            QuarkusMongoDBContainer mongoDBContainer = capturedProperties.imageName != null ? new QuarkusMongoDBContainer(DockerImageName.parse((String)capturedProperties.imageName).asCompatibleSubstituteFor("mongo"), capturedProperties.fixedExposedPort, useSharedNetwork) : new QuarkusMongoDBContainer(capturedProperties.fixedExposedPort, useSharedNetwork);
            timeout.ifPresent(arg_0 -> ((MongoDBContainer)mongoDBContainer).withStartupTimeout(arg_0));
            mongoDBContainer.withEnv(capturedProperties.containerEnv);
            mongoDBContainer.start();
            String effectiveUrl = this.getEffectiveUrl(configPrefix, mongoDBContainer.getHost(), mongoDBContainer.getMappedPort(27017), capturedProperties);
            return new DevServicesResultBuildItem.RunningDevService(Feature.MONGODB_CLIENT.getName(), mongoDBContainer.getContainerId(), () -> ((MongoDBContainer)mongoDBContainer).close(), this.getConfigPrefix(connectionName) + "connection-string", effectiveUrl);
        };
        return MONGO_CONTAINER_LOCATOR.locateContainer(capturedProperties.serviceName(), capturedProperties.shared(), launchMode).map(containerAddress -> {
            String effectiveUrl = this.getEffectiveUrl(configPrefix, containerAddress.getHost(), containerAddress.getPort(), capturedProperties);
            return new DevServicesResultBuildItem.RunningDevService(Feature.MONGODB_CLIENT.getName(), containerAddress.getId(), null, this.getConfigPrefix(connectionName) + "connection-string", effectiveUrl);
        }).orElseGet(defaultMongoServerSupplier);
    }

    private String getEffectiveUrl(String configPrefix, String host, int port, CapturedProperties capturedProperties) {
        String databaseName = ConfigProvider.getConfig().getOptionalValue(configPrefix + "database", String.class).orElse("test");
        Object effectiveUrl = String.format("%s%s:%d/%s", MONGO_SCHEME, host, port, databaseName);
        if (capturedProperties.connectionProperties != null && !capturedProperties.connectionProperties.isEmpty()) {
            effectiveUrl = (String)effectiveUrl + "?" + URLEncodedUtils.format((Iterable)capturedProperties.connectionProperties.entrySet().stream().map(e -> new BasicNameValuePair((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList()), (Charset)StandardCharsets.UTF_8);
        }
        return effectiveUrl;
    }

    private String getConfigPrefix(String connectionName) {
        Object configPrefix = "quarkus.mongodb.";
        if (!MongoClientBeanUtil.isDefault((String)connectionName)) {
            configPrefix = (String)configPrefix + connectionName + ".";
        }
        return configPrefix;
    }

    private Map<String, CapturedProperties> captureProperties(List<String> connectionNames, MongoClientBuildTimeConfig mongoClientBuildTimeConfig) {
        HashMap<String, CapturedProperties> result = new HashMap<String, CapturedProperties>();
        for (String connectionName : connectionNames) {
            result.put(connectionName, this.captureProperties(connectionName, mongoClientBuildTimeConfig));
        }
        return result;
    }

    private CapturedProperties captureProperties(String connectionName, MongoClientBuildTimeConfig mongoClientBuildTimeConfig) {
        String configPrefix = this.getConfigPrefix(connectionName);
        String databaseName = ConfigProvider.getConfig().getOptionalValue(configPrefix + "database", String.class).orElse(null);
        String connectionString = ConfigProvider.getConfig().getOptionalValue(configPrefix + "connection-string", String.class).orElse(null);
        DevServicesBuildTimeConfig devServicesConfig = mongoClientBuildTimeConfig.devservices;
        boolean devServicesEnabled = devServicesConfig.enabled.orElse(true);
        return new CapturedProperties(databaseName, connectionString, devServicesEnabled, devServicesConfig.imageName.orElseGet(() -> ConfigureUtil.getDefaultImageNameFor((String)"mongo")), devServicesConfig.port.orElse(null), devServicesConfig.properties, devServicesConfig.containerEnv, devServicesConfig.shared, devServicesConfig.serviceName);
    }

    static {
        first = true;
        MONGO_CONTAINER_LOCATOR = new ContainerLocator(DEV_SERVICE_LABEL, 27017);
    }

    private record CapturedProperties(String database, String connectionString, boolean devServicesEnabled, String imageName, Integer fixedExposedPort, Map<String, String> connectionProperties, Map<String, String> containerEnv, boolean shared, String serviceName) {
    }

    private static final class QuarkusMongoDBContainer
    extends MongoDBContainer {
        private final Integer fixedExposedPort;
        private final boolean useSharedNetwork;
        private String hostName = null;
        private static final int MONGODB_INTERNAL_PORT = 27017;

        private QuarkusMongoDBContainer(Integer fixedExposedPort, boolean useSharedNetwork) {
            this.fixedExposedPort = fixedExposedPort;
            this.useSharedNetwork = useSharedNetwork;
        }

        private QuarkusMongoDBContainer(DockerImageName dockerImageName, Integer fixedExposedPort, boolean useSharedNetwork) {
            super(dockerImageName);
            this.fixedExposedPort = fixedExposedPort;
            this.useSharedNetwork = useSharedNetwork;
        }

        public void configure() {
            super.configure();
            if (this.useSharedNetwork) {
                this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)"mongo");
                return;
            }
            if (this.fixedExposedPort != null) {
                this.addFixedExposedPort(this.fixedExposedPort, 27017);
            } else {
                this.addExposedPort(27017);
            }
        }

        public String getReplicaSetUrl(String databaseName) {
            if (this.useSharedNetwork) {
                if (!this.isRunning()) {
                    throw new IllegalStateException("MongoDBContainer should be started first");
                }
                return String.format("mongodb://%s:%d/%s", this.hostName, 27017, databaseName);
            }
            return super.getReplicaSetUrl(databaseName);
        }
    }
}

