/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.deployment;

import io.micrometer.core.annotation.Counted;
import io.micrometer.core.annotation.Timed;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.InterceptorBindingRegistrarBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.InterceptorBindingRegistrar;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.LogCategoryBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.metrics.MetricsFactoryConsumerBuildItem;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.ExternalPageBuilder;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.micrometer.deployment.MicrometerRegistryProviderBuildItem;
import io.quarkus.micrometer.deployment.RootMeterRegistryBuildItem;
import io.quarkus.micrometer.deployment.export.PrometheusRegistryProcessor;
import io.quarkus.micrometer.deployment.export.RegistryBuildItem;
import io.quarkus.micrometer.runtime.ClockProvider;
import io.quarkus.micrometer.runtime.CompositeRegistryCreator;
import io.quarkus.micrometer.runtime.MeterFilterConstraint;
import io.quarkus.micrometer.runtime.MeterFilterConstraints;
import io.quarkus.micrometer.runtime.MeterRegistryCustomizer;
import io.quarkus.micrometer.runtime.MeterRegistryCustomizerConstraint;
import io.quarkus.micrometer.runtime.MeterRegistryCustomizerConstraints;
import io.quarkus.micrometer.runtime.MeterTagsSupport;
import io.quarkus.micrometer.runtime.MicrometerCountedInterceptor;
import io.quarkus.micrometer.runtime.MicrometerRecorder;
import io.quarkus.micrometer.runtime.MicrometerTimedInterceptor;
import io.quarkus.micrometer.runtime.config.MicrometerConfig;
import io.quarkus.micrometer.runtime.export.exemplars.NoopOpenTelemetryExemplarContextUnwrapper;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import java.util.HashSet;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.logging.Level;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;

@BuildSteps(onlyIf={MicrometerEnabled.class})
public class MicrometerProcessor {
    private static final DotName METER_REGISTRY = DotName.createSimple((String)MeterRegistry.class.getName());
    private static final DotName METER_BINDER = DotName.createSimple((String)MeterBinder.class.getName());
    private static final DotName METER_FILTER = DotName.createSimple((String)MeterFilter.class.getName());
    private static final DotName METER_REGISTRY_CUSTOMIZER = DotName.createSimple((String)MeterRegistryCustomizer.class.getName());
    private static final DotName NAMING_CONVENTION = DotName.createSimple((String)NamingConvention.class.getName());
    private static final DotName COUNTED_ANNOTATION = DotName.createSimple((String)Counted.class.getName());
    private static final DotName COUNTED_INTERCEPTOR = DotName.createSimple((String)MicrometerCountedInterceptor.class.getName());
    private static final DotName TIMED_ANNOTATION = DotName.createSimple((String)Timed.class.getName());
    private static final DotName TIMED_INTERCEPTOR = DotName.createSimple((String)MicrometerTimedInterceptor.class.getName());
    private static final DotName METER_TAG_SUPPORT = DotName.createSimple((String)MeterTagsSupport.class.getName());
    private static final List<String> OPERATING_SYSTEM_BEAN_CLASS_NAMES = List.of("com.ibm.lang.management.OperatingSystemMXBean", "com.sun.management.OperatingSystemMXBean");
    MicrometerConfig mConfig;

    @BuildStep(onlyIfNot={PrometheusRegistryProcessor.PrometheusEnabled.class})
    MetricsCapabilityBuildItem metricsCapabilityBuildItem() {
        return new MetricsCapabilityBuildItem("micrometer"::equals, null);
    }

    @BuildStep(onlyIfNot={PrometheusRegistryProcessor.PrometheusEnabled.class})
    void registerEmptyExamplarProvider(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(NoopOpenTelemetryExemplarContextUnwrapper.class).setUnremovable().build());
    }

    @BuildStep(onlyIf={PrometheusRegistryProcessor.PrometheusEnabled.class})
    MetricsCapabilityBuildItem metricsCapabilityPrometheusBuildItem(NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem) {
        return new MetricsCapabilityBuildItem("micrometer"::equals, nonApplicationRootPathBuildItem.resolvePath(this.mConfig.export().prometheus().path()));
    }

    @BuildStep
    UnremovableBeanBuildItem registerAdditionalBeans(CombinedIndexBuildItem indexBuildItem, BuildProducer<MicrometerRegistryProviderBuildItem> providerClasses, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<InterceptorBindingRegistrarBuildItem> interceptorBindings, BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(ClockProvider.class).addBeanClass(CompositeRegistryCreator.class).addBeanClass(MeterRegistryCustomizer.class).build());
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(MeterFilterConstraint.class).addBeanClass(MeterFilterConstraints.class).addBeanClass(MeterRegistryCustomizerConstraint.class).addBeanClass(MeterRegistryCustomizerConstraints.class).addBeanClass(TIMED_ANNOTATION.toString()).addBeanClass(TIMED_INTERCEPTOR.toString()).addBeanClass(COUNTED_ANNOTATION.toString()).addBeanClass(COUNTED_INTERCEPTOR.toString()).addBeanClass(METER_TAG_SUPPORT.toString()).build());
        interceptorBindings.produce((BuildItem)new InterceptorBindingRegistrarBuildItem(new InterceptorBindingRegistrar(){

            public List<InterceptorBindingRegistrar.InterceptorBinding> getAdditionalBindings() {
                return List.of(InterceptorBindingRegistrar.InterceptorBinding.of(Timed.class, m -> true), InterceptorBindingRegistrar.InterceptorBinding.of(Counted.class, m -> true));
            }
        }));
        IndexView index = indexBuildItem.getIndex();
        reflectiveClasses.produce((BuildItem)this.createReflectiveBuildItem(COUNTED_ANNOTATION, index));
        reflectiveClasses.produce((BuildItem)this.createReflectiveBuildItem(TIMED_ANNOTATION, index));
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"org.HdrHistogram.Histogram", "org.HdrHistogram.DoubleHistogram", "org.HdrHistogram.ConcurrentHistogram"}).build());
        for (String beanClassName : OPERATING_SYSTEM_BEAN_CLASS_NAMES) {
            String reason = "Accessed by io.micrometer.core.instrument.binder.system.ProcessorMetrics.ProcessorMetrics(java.lang.Iterable<io.micrometer.core.instrument.Tag>)";
            reflectiveMethods.produce((BuildItem)new ReflectiveMethodBuildItem(reason, false, beanClassName, "getCpuLoad", new String[0]));
            reflectiveMethods.produce((BuildItem)new ReflectiveMethodBuildItem(reason, false, beanClassName, "getSystemCpuLoad", new String[0]));
            reflectiveMethods.produce((BuildItem)new ReflectiveMethodBuildItem(reason, false, beanClassName, "getProcessCpuLoad", new String[0]));
            reflectiveMethods.produce((BuildItem)new ReflectiveMethodBuildItem(reason, false, beanClassName, "getProcessCpuTime", new String[0]));
        }
        return UnremovableBeanBuildItem.beanTypes((DotName[])new DotName[]{METER_REGISTRY, METER_BINDER, METER_FILTER, METER_REGISTRY_CUSTOMIZER, NAMING_CONVENTION});
    }

    @BuildStep
    void configLoggingLevel(BuildProducer<LogCategoryBuildItem> logCategoryProducer) {
        logCategoryProducer.produce((BuildItem)new LogCategoryBuildItem("io.micrometer.core.instrument.composite.CompositeMeterRegistry", (Level)org.jboss.logmanager.Level.ERROR));
    }

    @BuildStep
    @Consume(value=BeanContainerBuildItem.class)
    @Record(value=ExecutionTime.STATIC_INIT)
    RootMeterRegistryBuildItem createRootRegistry(MicrometerRecorder recorder, MicrometerConfig config, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem) {
        RuntimeValue registry = recorder.createRootRegistry(config, nonApplicationRootPathBuildItem.getNonApplicationRootPath(), nonApplicationRootPathBuildItem.getNormalizedHttpRootPath());
        return new RootMeterRegistryBuildItem((RuntimeValue<MeterRegistry>)registry);
    }

    @BuildStep
    @Consume(value=RootMeterRegistryBuildItem.class)
    @Record(value=ExecutionTime.STATIC_INIT)
    void registerExtensionMetrics(MicrometerRecorder recorder, List<MetricsFactoryConsumerBuildItem> metricsFactoryConsumerBuildItems) {
        for (MetricsFactoryConsumerBuildItem item : metricsFactoryConsumerBuildItems) {
            if (item == null || item.executionTime() != ExecutionTime.STATIC_INIT) continue;
            recorder.registerMetrics(item.getConsumer());
        }
    }

    @BuildStep
    @Consume.List(value={@Consume(value=RootMeterRegistryBuildItem.class), @Consume(value=LoggingSetupBuildItem.class)})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void configureRegistry(MicrometerRecorder recorder, MicrometerConfig config, List<MicrometerRegistryProviderBuildItem> providerClassItems, List<MetricsFactoryConsumerBuildItem> metricsFactoryConsumerBuildItems, ShutdownContextBuildItem shutdownContextBuildItem) {
        HashSet<Class<? extends MeterRegistry>> typeClasses = new HashSet<Class<? extends MeterRegistry>>();
        for (MicrometerRegistryProviderBuildItem micrometerRegistryProviderBuildItem : providerClassItems) {
            typeClasses.add(micrometerRegistryProviderBuildItem.getRegistryClass());
        }
        recorder.configureRegistries(config, typeClasses, (ShutdownContext)shutdownContextBuildItem);
        for (MetricsFactoryConsumerBuildItem metricsFactoryConsumerBuildItem : metricsFactoryConsumerBuildItems) {
            if (metricsFactoryConsumerBuildItem == null || metricsFactoryConsumerBuildItem.executionTime() != ExecutionTime.RUNTIME_INIT) continue;
            recorder.registerMetrics(metricsFactoryConsumerBuildItem.getConsumer());
        }
    }

    ReflectiveClassBuildItem createReflectiveBuildItem(DotName sourceAnnotation, IndexView index) {
        HashSet<String> classes = new HashSet<String>();
        for (AnnotationInstance annotation : index.getAnnotations(sourceAnnotation)) {
            AnnotationTarget target = annotation.target();
            switch (target.kind()) {
                case METHOD: {
                    MethodInfo method = target.asMethod();
                    classes.add(method.declaringClass().name().toString());
                    break;
                }
                case TYPE: {
                    classes.add(target.asClass().name().toString());
                    break;
                }
            }
        }
        return ReflectiveClassBuildItem.builder((String[])classes.toArray(new String[0])).reason(this.getClass().getName()).build();
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    public CardPageBuildItem createCard(List<RegistryBuildItem> registries) {
        CardPageBuildItem card = new CardPageBuildItem();
        registries.stream().filter(r -> "JSON".equalsIgnoreCase(r.name())).findFirst().ifPresent(r -> card.addPage((PageBuilder)((ExternalPageBuilder)Page.externalPageBuilder((String)"JSON").icon("font-awesome-solid:chart-line")).url(r.path()).isJsonContent()));
        registries.stream().filter(r -> "Prometheus".equalsIgnoreCase(r.name())).findFirst().ifPresent(r -> {
            card.addPage((PageBuilder)((ExternalPageBuilder)Page.externalPageBuilder((String)"Prometheus").icon("font-awesome-solid:chart-line")).url(r.path()).isJsonContent());
            card.addPage((PageBuilder)((ExternalPageBuilder)Page.externalPageBuilder((String)"Prometheus (raw output)").doNotEmbed().icon("font-awesome-solid:up-right-from-square")).url(r.path()).mimeType("text/plain"));
        });
        return card;
    }

    public static class MicrometerEnabled
    implements BooleanSupplier {
        MicrometerConfig mConfig;

        @Override
        public boolean getAsBoolean() {
            return this.mConfig.enabled();
        }
    }
}

