/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.runtime;

import io.quarkus.smallrye.reactivemessaging.runtime.HealthCenterFilter;
import io.quarkus.smallrye.reactivemessaging.runtime.HealthCenterFilterConfig;
import io.smallrye.reactive.messaging.health.HealthReport;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.util.function.Function;

@Interceptor
@HealthCenterFilter
@Priority(value=5)
public class HealthCenterInterceptor {
    private final HealthCenterFilterConfig healthCenterFilterConfig;

    @Inject
    public HealthCenterInterceptor(HealthCenterFilterConfig healthCenterFilterConfig) {
        this.healthCenterFilterConfig = healthCenterFilterConfig;
    }

    @AroundInvoke
    public Object intercept(InvocationContext ctx) throws Exception {
        if (ctx.getMethod().getName().equals("getReadiness")) {
            HealthReport result = (HealthReport)ctx.proceed();
            return this.applyFilter(result, HealthCenterFilterConfig.HealthCenterConfig::readinessEnabled);
        }
        if (ctx.getMethod().getName().equals("getLiveness")) {
            HealthReport result = (HealthReport)ctx.proceed();
            return this.applyFilter(result, HealthCenterFilterConfig.HealthCenterConfig::livenessEnabled);
        }
        if (ctx.getMethod().getName().equals("getStartup")) {
            HealthReport result = (HealthReport)ctx.proceed();
            return this.applyFilter(result, HealthCenterFilterConfig.HealthCenterConfig::startupEnabled);
        }
        return ctx.proceed();
    }

    private HealthReport applyFilter(HealthReport result, Function<HealthCenterFilterConfig.HealthCenterConfig, Boolean> filterType) {
        if (this.healthCenterFilterConfig.health().isEmpty()) {
            return result;
        }
        HealthReport.HealthReportBuilder builder = HealthReport.builder();
        for (HealthReport.ChannelInfo channel : result.getChannels()) {
            HealthCenterFilterConfig.HealthCenterConfig config = this.healthCenterFilterConfig.health().get(channel.getChannel());
            if (config != null) {
                if (!config.enabled() || !filterType.apply(config).booleanValue()) continue;
                builder.add(channel);
                continue;
            }
            builder.add(channel);
        }
        return builder.build();
    }
}

