/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.runtime;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import io.smallrye.reactive.messaging.PublisherDecorator;
import io.smallrye.reactive.messaging.SubscriberDecorator;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.context.ThreadContext;
import org.eclipse.microprofile.reactive.messaging.Message;

@ApplicationScoped
public class ConnectorContextPropagationDecorator
implements PublisherDecorator,
SubscriberDecorator {
    private final ThreadContext tc;

    @Inject
    public ConnectorContextPropagationDecorator(@ConfigProperty(name="quarkus.messaging.connector-context-propagation") Optional<List<String>> propagation) {
        this.tc = ThreadContext.builder().propagated(propagation.map(l -> (String[])l.toArray(String[]::new)).orElse(ThreadContext.NONE)).cleared(new String[]{"Remaining"}).build();
    }

    public Multi<? extends Message<?>> decorate(Multi<? extends Message<?>> publisher, List<String> channelName, boolean isConnector) {
        if (isConnector) {
            return new ContextPropagationOperator(publisher, this.tc);
        }
        return publisher;
    }

    public int getPriority() {
        return -100;
    }

    public static class ContextPropagationOperator<T>
    extends AbstractMultiOperator<T, T> {
        private final ThreadContext tc;

        public ContextPropagationOperator(Multi<? extends T> upstream, ThreadContext tc) {
            super(upstream);
            this.tc = tc;
        }

        public void subscribe(MultiSubscriber<? super T> downstream) {
            ParameterValidation.nonNullNpe(downstream, (String)"subscriber");
            this.upstream.subscribe().withSubscriber(new ContextPropagationProcessor<T>(downstream, this.tc));
        }

        static final class ContextPropagationProcessor<T>
        extends MultiOperatorProcessor<T, T> {
            private final Executor tcExecutor;

            public ContextPropagationProcessor(MultiSubscriber<? super T> downstream, ThreadContext tc) {
                super(downstream);
                this.tcExecutor = tc.currentContextExecutor();
            }

            public void onItem(T item) {
                this.tcExecutor.execute(() -> super.onItem(item));
            }
        }
    }
}

