/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.load.shedding.runtime;

import com.sun.management.OperatingSystemMXBean;
import io.quarkus.arc.All;
import io.quarkus.load.shedding.RequestClassifier;
import io.quarkus.load.shedding.RequestPrioritizer;
import io.quarkus.load.shedding.RequestPriority;
import io.quarkus.load.shedding.runtime.LoadSheddingRuntimeConfig;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.management.ManagementFactory;
import java.util.List;

@Singleton
public class PriorityLoadShedding {
    @Inject
    @All
    List<RequestPrioritizer<?>> requestPrioritizers;
    @Inject
    @All
    List<RequestClassifier<?>> requestClassifiers;
    private final boolean enabled;
    private final int max;
    private final OperatingSystemMXBean os;
    private double lastThreshold;
    private long lastThresholdTime;

    @Inject
    PriorityLoadShedding(LoadSheddingRuntimeConfig config) {
        this.enabled = config.priority().enabled();
        this.max = RequestPriority.values().length * 128;
        this.os = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shedLoad(Object request) {
        if (!this.enabled) {
            return true;
        }
        long now = System.currentTimeMillis();
        PriorityLoadShedding priorityLoadShedding = this;
        synchronized (priorityLoadShedding) {
            if (now - this.lastThresholdTime > 1000L) {
                double load = this.os.getCpuLoad();
                this.lastThreshold = load < 0.0 ? -1.0 : (double)this.max * (1.0 - load * load * load);
                this.lastThresholdTime = now;
            }
        }
        double threshold = this.lastThreshold;
        if (threshold < 0.0) {
            return true;
        }
        RequestPriority priority = RequestPriority.NORMAL;
        for (RequestPrioritizer<?> requestPrioritizer : this.requestPrioritizers) {
            if (!requestPrioritizer.appliesTo(request)) continue;
            priority = requestPrioritizer.priority(request);
            break;
        }
        int cohort = 64;
        for (RequestClassifier<?> requestClassifier : this.requestClassifiers) {
            if (!requestClassifier.appliesTo(request)) continue;
            cohort = requestClassifier.cohort(request);
            break;
        }
        if (cohort == Integer.MIN_VALUE) {
            cohort = 128;
        } else if (cohort < 0) {
            cohort = -cohort % 128 + 1;
        } else if (cohort == 0) {
            cohort = 1;
        } else if (cohort > 128) {
            cohort = cohort % 128 + 1;
        }
        return (double)(priority.cohortBaseline() + cohort) > threshold;
    }
}

