/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.quarkus.kubernetes.spi.Property;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.jboss.logging.Logger;

public class PropertyUtil {
    private static final Set<String> VISITED_EXTENSION_PROPERTIES = new HashSet<String>();
    private static final Logger LOG = Logger.getLogger(PropertyUtil.class);

    public static <T> void printMessages(String usage, String platform, Property<T> kubernetesProperty, Optional<Property<T>> extensionProperty) {
        extensionProperty.ifPresent(p -> PropertyUtil.printMessages(usage, platform, kubernetesProperty, p));
    }

    public static <T> void printMessages(String usage, String platform, Property<T> kubernetesProperty, Property<T> extensionProperty) {
        if (!VISITED_EXTENSION_PROPERTIES.add(extensionProperty.getName())) {
            return;
        }
        Object platformCapitalized = platform.replace("openshift", "OpenShift");
        platformCapitalized = ((String)platformCapitalized).substring(0, 1).toUpperCase() + ((String)platformCapitalized).substring(1);
        Object kubernetesValue = kubernetesProperty.getValue().orElse(null);
        if (kubernetesValue == null) {
            String defaultOrProvided = extensionProperty.getValue().isPresent() ? "provided" : "default";
            String stringValue = String.valueOf(extensionProperty.getValue().orElse(extensionProperty.getDefaultValue()));
            LOG.infof("%s manifests are generated with '%s' having %s value '%s'. The app and manifests will get out of sync if the property '%s' is changed at runtime.", new Object[]{platformCapitalized, usage, defaultOrProvided, stringValue, extensionProperty.getName()});
        } else if (extensionProperty.getValue().filter(v -> !v.equals(kubernetesValue)).isPresent()) {
            String runtimeOrBuildTime = extensionProperty.isRuntime() ? "runtime" : "buildtime";
            LOG.debugf("%s property '%s' has been set with value '%s' while %s property '%s' is set with '%s'. %s will be set using the former.", new Object[]{platformCapitalized, kubernetesProperty.getName(), kubernetesProperty.getValue().get(), runtimeOrBuildTime, extensionProperty.getName(), extensionProperty.getValue().get(), usage});
        }
    }
}

