/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.EnvBuilder;
import io.quarkus.kubernetes.deployment.EnvConfig;
import io.quarkus.kubernetes.deployment.EnvVarPrefixConfig;
import io.quarkus.kubernetes.deployment.EnvVarsConfig;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class EnvConverter {
    public static Env convert(Map.Entry<String, EnvConfig> e) {
        return ((EnvBuilder)EnvConverter.convert(e.getValue()).withName(EnvConverter.convertName(e.getKey()))).build();
    }

    private static EnvBuilder convert(EnvConfig env) {
        EnvBuilder b = new EnvBuilder();
        env.name().ifPresent(arg_0 -> ((EnvBuilder)b).withName(arg_0));
        env.value().ifPresent(arg_0 -> ((EnvBuilder)b).withValue(arg_0));
        env.secret().ifPresent(arg_0 -> ((EnvBuilder)b).withSecret(arg_0));
        env.configmap().ifPresent(arg_0 -> ((EnvBuilder)b).withConfigmap(arg_0));
        env.field().ifPresent(arg_0 -> ((EnvBuilder)b).withField(arg_0));
        return b;
    }

    public static List<Env> convert(EnvVarsConfig e) {
        LinkedList<Env> envs = new LinkedList<Env>();
        Map<String, EnvVarPrefixConfig> prefixMap = EnvConverter.collectPrefixes(e);
        e.secrets().ifPresent(sl -> sl.forEach(s -> envs.add((Env)((EnvBuilder)((EnvBuilder)((EnvBuilder)new EnvBuilder().withName(EnvConverter.convertName(s))).withSecret(s)).withPrefix((String)EnvConverter.extractSecretPrefix(s, prefixMap).orElse(null))).build())));
        e.configmaps().ifPresent(cl -> cl.forEach(c -> envs.add((Env)((EnvBuilder)((EnvBuilder)((EnvBuilder)new EnvBuilder().withName(EnvConverter.convertName(c))).withConfigmap(c)).withPrefix((String)EnvConverter.extractConfigmapPrefix(c, prefixMap).orElse(null))).build())));
        e.vars().forEach((k, v) -> envs.add((Env)((EnvBuilder)((EnvBuilder)new EnvBuilder().withName(EnvConverter.convertName(k))).withValue(v.value().orElse(""))).build()));
        e.fields().forEach((k, v) -> {
            String field = EnvConverter.convertName(k);
            envs.add((Env)((EnvBuilder)((EnvBuilder)((EnvBuilder)new EnvBuilder().withName(field)).withField(field)).withValue(v)).build());
        });
        e.mapping().forEach((k, v) -> envs.add((Env)((EnvBuilder)((EnvBuilder)((EnvBuilder)((EnvBuilder)new EnvBuilder().withName(EnvConverter.convertName(k))).withSecret((String)v.fromSecret().orElse(null))).withConfigmap((String)v.fromConfigmap().orElse(null))).withValue(v.withKey())).build()));
        return envs;
    }

    public static String convertName(String name) {
        return name != null ? name.toUpperCase().replace('-', '_').replace('.', '_').replace('/', '_') : null;
    }

    public static Optional<String> extractSecretPrefix(String secret, Map<String, EnvVarPrefixConfig> mappingWithPrefix) {
        return mappingWithPrefix.entrySet().stream().filter(m -> ((EnvVarPrefixConfig)m.getValue()).hasPrefixForSecret(secret)).findFirst().map(Map.Entry::getKey);
    }

    public static Optional<String> extractConfigmapPrefix(String configmap, Map<String, EnvVarPrefixConfig> mappingWithPrefix) {
        return mappingWithPrefix.entrySet().stream().filter(m -> ((EnvVarPrefixConfig)m.getValue()).hasPrefixForConfigmap(configmap)).findFirst().map(Map.Entry::getKey);
    }

    public static Map<String, EnvVarPrefixConfig> collectPrefixes(EnvVarsConfig e) {
        return e.prefixes().entrySet().stream().filter(p -> ((EnvVarPrefixConfig)p.getValue()).anyPresent() && p.getKey() != null && !((String)p.getKey()).isBlank()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

