/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.container.spi.ContainerImageBuildRequestBuildItem;
import io.quarkus.container.spi.ContainerImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImagePushRequestBuildItem;
import io.quarkus.container.spi.FallbackContainerImageRegistryBuildItem;
import io.quarkus.deployment.IsNormalNotRemoteDev;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.kubernetes.client.spi.KubernetesClientBuildItem;
import io.quarkus.kubernetes.deployment.KubernetesDeploy;
import io.quarkus.kubernetes.deployment.PreventImplicitContainerImagePushBuildItem;
import io.quarkus.kubernetes.deployment.SelectedKubernetesDeploymentTargetBuildItem;
import java.util.List;
import java.util.Optional;

public class KubernetesDeployerPrerequisite {
    @BuildStep(onlyIf={IsNormalNotRemoteDev.class})
    public void prepare(ContainerImageInfoBuildItem containerImage, KubernetesClientBuildItem kubernetesClientBuilder, Optional<SelectedKubernetesDeploymentTargetBuildItem> selectedDeploymentTarget, Optional<FallbackContainerImageRegistryBuildItem> fallbackRegistry, List<PreventImplicitContainerImagePushBuildItem> preventImplicitContainerImagePush, BuildProducer<ContainerImageBuildRequestBuildItem> buildRequestProducer, BuildProducer<ContainerImagePushRequestBuildItem> pushRequestProducer) {
        boolean registryIsPresent;
        if (!KubernetesDeploy.INSTANCE.checkSilently(kubernetesClientBuilder) || !selectedDeploymentTarget.isPresent()) {
            return;
        }
        buildRequestProducer.produce((BuildItem)new ContainerImageBuildRequestBuildItem());
        boolean bl = registryIsPresent = containerImage.getRegistry().isPresent() || fallbackRegistry.isPresent();
        if (registryIsPresent && preventImplicitContainerImagePush.isEmpty()) {
            pushRequestProducer.produce((BuildItem)new ContainerImagePushRequestBuildItem());
        }
    }
}

