/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.Set;

public enum DeploymentResourceKind {
    Deployment("Deployment", "apps", "v1", new String[0]),
    DeploymentConfig("DeploymentConfig", "apps.openshift.io", "v1", "openshift"),
    StatefulSet("StatefulSet", "apps", "v1", new String[0]),
    Job("Job", "batch", "v1", new String[0]),
    CronJob("CronJob", "batch", "v1", new String[0]),
    KnativeService("Service", "serving.knative.dev", "v1", "knative");

    private final String kind;
    private final String group;
    private final String version;
    private final Set<String> requiredTargets;

    private DeploymentResourceKind(String kind, String group, String version, String ... requiredTargets) {
        this(kind, group, version, Set.of(requiredTargets));
    }

    private DeploymentResourceKind(String kind, String group, String version, Set<String> requiredTargets) {
        this.kind = kind;
        this.group = group;
        this.version = version;
        this.requiredTargets = requiredTargets;
    }

    public static DeploymentResourceKind find(String apiGroup, String apiVersion, String kind) {
        for (DeploymentResourceKind deploymentResourceKind : DeploymentResourceKind.values()) {
            if (!deploymentResourceKind.kind.equals(kind) || !deploymentResourceKind.group.equals(apiGroup) || !deploymentResourceKind.version.equals(apiVersion)) continue;
            return deploymentResourceKind;
        }
        String apiGroupVersion = Strings.isNullOrEmpty((String)apiGroup) ? apiVersion : apiGroup + "/" + apiVersion;
        throw new IllegalArgumentException("Could not find DeploymentResourceKind for " + apiGroupVersion + " " + kind);
    }

    public boolean isAvailalbleOn(String target) {
        return this.requiredTargets.isEmpty() || this.requiredTargets.contains(target);
    }

    public boolean matches(HasMetadata resource) {
        String resourceKind = HasMetadata.getKind(resource.getClass());
        String resourceVersion = HasMetadata.getApiVersion(resource.getClass());
        return resourceKind.equals(this.getKind()) && resourceVersion.equals(this.getApiVersion());
    }

    public String getKind() {
        return this.kind;
    }

    public String getGroup() {
        return this.group;
    }

    public String getVersion() {
        return this.version;
    }

    public Set<String> getRequiredTargets() {
        return this.requiredTargets;
    }

    public String getApiVersion() {
        return this.group + "/" + this.version;
    }
}

