/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.ConfigReference;
import io.dekorate.WithConfigReferences;
import io.dekorate.kubernetes.decorator.AddInitContainerDecorator;
import io.dekorate.kubernetes.decorator.AddSidecarDecorator;
import io.dekorate.kubernetes.decorator.ApplicationContainerDecorator;
import io.dekorate.kubernetes.decorator.ApplyImageDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import java.util.Arrays;
import java.util.List;

public class ApplyContainerImageDecorator
extends ApplicationContainerDecorator<ContainerFluent>
implements WithConfigReferences {
    private final String image;

    public ApplyContainerImageDecorator(String containerName, String image) {
        super((String)null, containerName);
        this.image = image;
    }

    public ApplyContainerImageDecorator(String deploymentName, String containerName, String image) {
        super(deploymentName, containerName);
        this.image = image;
    }

    public void andThenVisit(ContainerFluent container) {
        container.withImage(this.image);
    }

    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class, AddSidecarDecorator.class, AddInitContainerDecorator.class, ApplyImageDecorator.class};
    }

    public List<ConfigReference> getConfigReferences() {
        return Arrays.asList(this.buildConfigReferenceForImage());
    }

    private ConfigReference buildConfigReferenceForImage() {
        String property = "image";
        Object path = "spec.template.spec.containers.image";
        if (!Strings.equals((String)this.getDeploymentName(), (String)ANY) && !Strings.equals((String)this.getContainerName(), (String)ANY)) {
            path = "(metadata.name == " + this.getDeploymentName() + ")].spec.template.spec.containers.(name == " + this.getContainerName() + ").image";
        } else if (!Strings.equals((String)this.getDeploymentName(), (String)ANY)) {
            path = "(metadata.name == " + this.getDeploymentName() + ").spec.template.spec.containers.image";
        } else if (!Strings.equals((String)this.getContainerName(), (String)ANY)) {
            path = "spec.template.spec.containers.(name == " + this.getContainerName() + ").image";
        }
        return new ConfigReference.Builder(property, (String)path).withValue((Object)this.image).withDescription("The container image to use.").build();
    }
}

