/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kafka.client.runtime.dev.ui;

import io.quarkus.kafka.client.runtime.KafkaAdminClient;
import io.quarkus.kafka.client.runtime.KafkaCreateTopicRequest;
import io.quarkus.kafka.client.runtime.dev.ui.KafkaUiUtils;
import io.quarkus.kafka.client.runtime.dev.ui.model.Order;
import io.quarkus.kafka.client.runtime.dev.ui.model.request.KafkaMessageCreateRequest;
import io.quarkus.kafka.client.runtime.dev.ui.model.request.KafkaMessagesRequest;
import io.quarkus.kafka.client.runtime.dev.ui.model.request.KafkaOffsetRequest;
import io.quarkus.kafka.client.runtime.dev.ui.model.response.KafkaAclInfo;
import io.quarkus.kafka.client.runtime.dev.ui.model.response.KafkaInfo;
import io.quarkus.kafka.client.runtime.dev.ui.model.response.KafkaMessagePage;
import io.quarkus.kafka.client.runtime.dev.ui.model.response.KafkaTopic;
import io.quarkus.runtime.annotations.JsonRpcDescription;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.operators.multi.processors.BroadcastProcessor;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class KafkaJsonRPCService {
    @Inject
    KafkaUiUtils kafkaUiUtils;
    @Inject
    KafkaAdminClient kafkaAdminClient;
    private final BroadcastProcessor<String> stateNotification = BroadcastProcessor.create();
    private static final String TOPIC = "topic";
    private static final String MESSAGE = "message";

    public Multi<String> stateNotification() {
        return this.stateNotification;
    }

    @JsonRpcDescription(value="Get all the current Kafka topics")
    public List<KafkaTopic> getTopics() throws InterruptedException, ExecutionException {
        return this.kafkaUiUtils.getTopics();
    }

    @JsonRpcDescription(value="Create a new Kafka topic")
    public List<KafkaTopic> createTopic(@JsonRpcDescription(value="The Kafka topic name") String topicName, @JsonRpcDescription(value="The number of partitions, example 1") int partitions, @JsonRpcDescription(value="The number of replications, example 1") int replications, @JsonRpcDescription(value="Other config in map format (key/value)") Map<String, String> configs) throws InterruptedException, ExecutionException {
        KafkaCreateTopicRequest createTopicRequest = new KafkaCreateTopicRequest(topicName, Integer.valueOf(partitions), Short.valueOf((short)replications), configs);
        boolean created = this.kafkaAdminClient.createTopic(createTopicRequest);
        if (created) {
            this.stateNotification.onNext((Object)TOPIC);
            return this.kafkaUiUtils.getTopics();
        }
        throw new RuntimeException("Topic [" + topicName + "] not created");
    }

    @JsonRpcDescription(value="Delete an existing Kafka topic")
    public List<KafkaTopic> deleteTopic(@JsonRpcDescription(value="The Kafka topic name") String topicName) throws InterruptedException, ExecutionException {
        boolean deleted = this.kafkaAdminClient.deleteTopic(topicName);
        if (deleted) {
            this.stateNotification.onNext((Object)TOPIC);
            return this.kafkaUiUtils.getTopics();
        }
        throw new RuntimeException("Topic [" + topicName + "] not deleted");
    }

    @JsonRpcDescription(value="Get all the current messages for a certain Kafka topics")
    public KafkaMessagePage topicMessages(@JsonRpcDescription(value="The Kafka topic name") String topicName) throws ExecutionException, InterruptedException {
        List<Integer> partitions = this.getPartitions(topicName);
        KafkaOffsetRequest offsetRequest = new KafkaOffsetRequest(topicName, partitions, Order.NEW_FIRST);
        Map<Integer, Long> offset = this.kafkaUiUtils.getOffset(offsetRequest);
        KafkaMessagesRequest request = new KafkaMessagesRequest(topicName, Order.NEW_FIRST, 20, offset);
        return this.kafkaUiUtils.getMessages(request);
    }

    @JsonRpcDescription(value="Create a new message on a specific Kafka topic")
    public KafkaMessagePage createMessage(@JsonRpcDescription(value="The Kafka topic name") String topicName, @JsonRpcDescription(value="The partition number, example 1") Integer partition, @JsonRpcDescription(value="The message key") String key, @JsonRpcDescription(value="The message value") String value, @JsonRpcDescription(value="The message headers in map format (key/value)") Map<String, String> headers) throws ExecutionException, InterruptedException {
        if (partition < 0) {
            partition = null;
        }
        KafkaMessageCreateRequest request = new KafkaMessageCreateRequest(topicName, partition, value, key, headers);
        this.kafkaUiUtils.createMessage(request);
        this.stateNotification.onNext((Object)MESSAGE);
        return this.topicMessages(topicName);
    }

    @JsonRpcDescription(value="Get the partitions for a specific Kafka topic")
    public List<Integer> getPartitions(@JsonRpcDescription(value="The Kafka topic name") String topicName) throws ExecutionException, InterruptedException {
        return new ArrayList<Integer>(this.kafkaUiUtils.partitions(topicName));
    }

    @JsonRpcDescription(value="Get all know information on the Kafka instance")
    public KafkaInfo getInfo() throws ExecutionException, InterruptedException {
        return this.kafkaUiUtils.getKafkaInfo();
    }

    @JsonRpcDescription(value="Get all know information about the use access control lists for authorization in Kafka")
    public KafkaAclInfo getAclInfo() throws InterruptedException, ExecutionException {
        return this.kafkaUiUtils.getAclInfo();
    }
}

